set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '4113340',
      118,
      4,
      1.682149,
      3,
      NULL,
      2.718640,
      ' 1- 2-1983',
      NULL,
      NULL,
      0,
      NULL,
      2.634010,
      0.664666,
      0,
      1.964262,
      0.249018,
      2,
      0.215467,
      0,
      0,
      0,
      NULL,
      0.095615,
      NULL,
      5.693487,
      4.116343,
      1.878484,
      7,
      1,
      1,
      NULL,
      1.890327,
      0,
      4.685635,
      NULL,
      2.140659,
      0.130813,
      1,
      NULL,
      NULL,
      NULL,
      1.107382,
      NULL,
      NULL,
      0.337646,
      3,
      0.923940,
      NULL,
      0,
      1.719620,
      NULL,
      NULL,
      2,
      0.144072,
      NULL,
      3.563072,
      0.968399,
      3.963031,
      0,
      3.940912,
      0.758220,
      NULL,
      0,
      0.269516,
      1,
      1,
      6,
      0,
      0,
      3.851530,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      0.675792,
      1,
      5.982277,
      3,
      2.712654,
      NULL,
      1.265298,
      NULL,
      NULL,
      1.117664,
      0.171081,
      0.833826,
      0,
      NULL,
      0.477420,
      4.700417,
      7.962829,
      NULL,
      NULL,
      1.941599,
      4.289044,
      0,
      3.126931,
      1.439009,
      2,
      0,
      0.806041,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      5.997399,
      6.545312,
      0,
      4,
      2.782502,
      0.196003,
      NULL,
      5,
      0,
      0,
      1,
      0.625720,
      1,
      0.473612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0.351579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.721094,
      NULL,
      1,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.335469,
      NULL,
      0.360483,
      2.912289,
      NULL,
      2,
      0.296096,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.119336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.183688,
      NULL,
      1,
      NULL,
      1.309635,
      2,
      1.969388,
      3,
      1,
      1.034136,
      1.634844,
      1.783678,
      NULL,
      1.468448,
      0,
      1.321026,
      1.278983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '22204',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


