set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '1400311',
      131,
      3,
      NULL,
      0,
      '110232',
      1.592601,
      ' 8- 5-2002',
      8.192211,
      NULL,
      1,
      NULL,
      2.473673,
      0.199087,
      0,
      1.374999,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.201605,
      NULL,
      NULL,
      4,
      2.619424,
      1.793267,
      3.997998,
      1,
      0,
      NULL,
      0,
      1,
      4,
      1,
      2.801119,
      0.843090,
      1.929157,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246893,
      3,
      NULL,
      1.193149,
      1.032592,
      1.759586,
      1.576221,
      NULL,
      NULL,
      0.013564,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.726364,
      0,
      0,
      1,
      0.166424,
      NULL,
      NULL,
      0,
      1,
      1.425164,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.202228,
      1,
      3.353975,
      6.140717,
      1.286589,
      0.102364,
      1.482722,
      2,
      2.316302,
      0,
      NULL,
      0,
      NULL,
      1.634223,
      1.035069,
      1.998382,
      NULL,
      1.438123,
      1,
      7.847930,
      5,
      6,
      1.063974,
      5.501178,
      0.378856,
      NULL,
      0,
      1.129620,
      1.286378,
      NULL,
      0.632250,
      0.068286,
      NULL,
      NULL,
      0,
      6.438018,
      NULL,
      5.172576,
      4,
      NULL,
      2,
      6.199171,
      NULL,
      1,
      NULL,
      3.805869,
      0.745097,
      0,
      4.005301,
      1.804374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756306,
      1,
      0,
      1,
      1.108627,
      1,
      1.054114,
      1.780050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.521783,
      0.704235,
      0,
      1.965230,
      NULL,
      4,
      1.474893,
      0.166970,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790377,
      1,
      NULL,
      0.069549,
      2,
      1.492540,
      NULL,
      NULL,
      NULL,
      NULL,
      7.163004,
      1.950000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.809427,
      0,
      0.287181,
      NULL,
      1,
      0.750863,
      0.593873,
      3,
      1.170845,
      NULL,
      1.693720,
      1.993249,
      NULL,
      0.761972,
      NULL,
      1,
      0,
      0.132622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '12123',
      '',
      '',
      1.343329,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


