set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '0304210',
      NULL,
      NULL,
      NULL,
      0,
      '220342',
      3.208229,
      ' 3- 9-1977',
      8.816576,
      NULL,
      0,
      NULL,
      2.352251,
      NULL,
      1.777512,
      0,
      NULL,
      3,
      0,
      0.998367,
      1,
      0.031191,
      1,
      0,
      0,
      1,
      2.167912,
      NULL,
      0.154108,
      1.521167,
      1,
      1,
      0,
      1.758680,
      NULL,
      0,
      0,
      1,
      1.893665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339090,
      NULL,
      0,
      1.016026,
      1,
      NULL,
      NULL,
      3.472248,
      0.131211,
      0.980929,
      0,
      0.178557,
      1.579879,
      0.980748,
      0,
      1.968796,
      NULL,
      1.218877,
      1.136456,
      0.705183,
      NULL,
      5.634603,
      0,
      1,
      1.928393,
      0.853654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233993,
      1,
      NULL,
      0,
      0.018361,
      0.061684,
      NULL,
      1.714617,
      0.537684,
      1.208327,
      0,
      NULL,
      0.316953,
      3,
      0,
      0.191210,
      0.857592,
      0.921356,
      0.759991,
      NULL,
      1.848430,
      1.992040,
      1.698397,
      1,
      7,
      1,
      9,
      NULL,
      2.435378,
      3.758509,
      3,
      0.316016,
      1.279856,
      NULL,
      NULL,
      0.946673,
      0.125827,
      7.316612,
      NULL,
      1.372492,
      NULL,
      0.892377,
      NULL,
      3.187040,
      6,
      2.031617,
      5.144336,
      7.939517,
      2,
      0,
      1,
      3.853262,
      0.097385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.425985,
      0,
      NULL,
      NULL,
      0,
      1,
      1.773212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      1.295586,
      NULL,
      NULL,
      NULL,
      0.031025,
      0.380584,
      5.001843,
      4.245474,
      0.923743,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.475387,
      9.227551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528692,
      NULL,
      1,
      1.002084,
      1,
      0,
      0.562809,
      NULL,
      NULL,
      1,
      NULL,
      0.667529,
      NULL,
      1.396772,
      1,
      0,
      1.714426,
      0.546516,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '02001',
      NULL,
      '',
      1.611842,
      '',
      '',
      '',
      1.567243,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


