set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '3123134',
      93.971733,
      6,
      2,
      1,
      NULL,
      2,
      ' 5-26-1984',
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016555,
      NULL,
      NULL,
      1.274618,
      3,
      1,
      NULL,
      2.934806,
      0,
      6.867353,
      0,
      1.355220,
      NULL,
      4,
      NULL,
      NULL,
      0.999170,
      0.741711,
      1.799861,
      1.674920,
      1.316249,
      NULL,
      0,
      5,
      1.065960,
      3.899985,
      1.625979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.438213,
      1.091628,
      3,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.759666,
      1,
      3,
      0,
      1,
      0,
      0,
      1.364031,
      1.269963,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.850871,
      3,
      NULL,
      3,
      5.532120,
      1.774108,
      0,
      1,
      1.000269,
      0.344768,
      1.202383,
      NULL,
      0.223450,
      2.540338,
      0.770141,
      0,
      NULL,
      1.872087,
      NULL,
      NULL,
      0,
      2,
      1.818695,
      0.467105,
      6.275797,
      1.230074,
      7,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      0.909187,
      2,
      1.118864,
      1,
      8.740902,
      4,
      1.105146,
      3,
      NULL,
      1.666814,
      NULL,
      NULL,
      NULL,
      3.657579,
      2.702426,
      2.877076,
      0,
      0.909973,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499211,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.078330,
      0,
      0.659845,
      0,
      0.134782,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6.474431,
      NULL,
      0.623593,
      0.206249,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.507949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167697,
      NULL,
      NULL,
      0.791745,
      1,
      NULL,
      1.205441,
      1,
      1.086536,
      3,
      1,
      0,
      1.194900,
      0.810472,
      NULL,
      1.111758,
      0.361230,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '11232',
      '',
      '',
      1.169968,
      NULL,
      '',
      '',
      1.451218,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


