set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '11',
      24.381480,
      4,
      NULL,
      76.307978,
      0,
      1,
      1,
      '034401',
      4,
      ' 5- 9-1985',
      46.904603,
      NULL,
      1.167411,
      NULL,
      2.219260,
      0.592754,
      3.579591,
      1,
      1.068538,
      3,
      NULL,
      1.614648,
      0.742364,
      1,
      4.141126,
      1,
      1.193376,
      9.157057,
      4,
      0,
      0.431831,
      10,
      NULL,
      NULL,
      5,
      0.484309,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.671854,
      NULL,
      NULL,
      7.391139,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      0,
      3,
      0,
      NULL,
      2,
      1,
      NULL,
      0.243137,
      NULL,
      NULL,
      1.552990,
      0.245577,
      0.652205,
      0,
      2,
      3,
      1,
      0,
      0.762602,
      1,
      NULL,
      NULL,
      0.893880,
      NULL,
      NULL,
      1.436486,
      1,
      3,
      1,
      3.035890,
      1,
      4.396943,
      1.238666,
      1.398784,
      0,
      1.018300,
      0.236451,
      1,
      3.261707,
      0,
      1.246730,
      0,
      0.174929,
      0,
      NULL,
      1,
      NULL,
      4.662862,
      6,
      NULL,
      0,
      NULL,
      0,
      4,
      0,
      4,
      3.915594,
      NULL,
      1.740343,
      1.368125,
      NULL,
      NULL,
      NULL,
      3.430592,
      NULL,
      6,
      NULL,
      NULL,
      10.256569,
      6.418071,
      3,
      9,
      7.532088,
      0.791539,
      1,
      0.594966,
      1.821482,
      1.354596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.705475,
      NULL,
      0,
      0.040263,
      NULL,
      0,
      0.733675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.845237,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.206173,
      0.400426,
      0.606602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884487,
      NULL,
      1.436681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105397,
      2.000264,
      3,
      0,
      NULL,
      0.303440,
      3,
      3.053736,
      0,
      NULL,
      0.331156,
      0,
      1.753116,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044778,
      '12023',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


