set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23',
      NULL,
      NULL,
      '2434214',
      26,
      6,
      0,
      0,
      NULL,
      1.224900,
      ' 3-18-1983',
      18,
      24,
      0.310127,
      NULL,
      0,
      1,
      0.813714,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.372055,
      1,
      4,
      0.518006,
      2.859229,
      5,
      2,
      3.047641,
      1.411420,
      1,
      3.123115,
      3.926173,
      0,
      0.775341,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.172536,
      0,
      0.152182,
      1,
      NULL,
      0,
      NULL,
      0.310115,
      3.647383,
      NULL,
      3.653145,
      0,
      1.259118,
      0.088138,
      1,
      1,
      NULL,
      1.449639,
      1,
      8,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.810688,
      NULL,
      NULL,
      1,
      0,
      2.287053,
      3.766676,
      4.841814,
      NULL,
      NULL,
      1,
      NULL,
      0.427796,
      1.523628,
      1.452983,
      0.630021,
      2,
      1.597249,
      0,
      1.346040,
      0.525105,
      0.960984,
      NULL,
      0,
      2.934985,
      NULL,
      1,
      1.784207,
      NULL,
      0,
      NULL,
      0,
      0.005276,
      4,
      0.482316,
      3,
      2,
      2.852372,
      NULL,
      0.940593,
      8,
      6,
      6,
      7.284207,
      0.545552,
      6,
      1,
      0,
      3,
      7.483859,
      NULL,
      3,
      0.199257,
      0.041725,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818668,
      1,
      0,
      1,
      NULL,
      NULL,
      0.295062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449731,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2,
      1.498283,
      NULL,
      NULL,
      NULL,
      NULL,
      2.042389,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.119741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.404946,
      1,
      0,
      1,
      0,
      NULL,
      3.668632,
      3.431415,
      NULL,
      1,
      0.365282,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.555021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.165330,
      '03322',
      '',
      '',
      0.969729,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.962236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


