set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      NULL,
      9,
      2,
      '4434131',
      197.343582,
      1,
      1,
      2,
      '120302',
      5,
      ' 4-11-2000',
      21,
      22,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.470332,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      6.317403,
      1.256101,
      3.090439,
      4.096136,
      1,
      0,
      3,
      0,
      0,
      7.295719,
      0,
      1,
      NULL,
      NULL,
      1.602497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      4,
      3,
      1.167128,
      1,
      2.148592,
      3,
      NULL,
      1.668148,
      NULL,
      2.502927,
      1,
      3,
      0,
      0.873508,
      NULL,
      NULL,
      1,
      0,
      1.242007,
      0,
      NULL,
      0,
      2,
      NULL,
      1.969856,
      NULL,
      NULL,
      1.977631,
      NULL,
      NULL,
      0,
      0.483853,
      2.185080,
      3,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.619553,
      NULL,
      0.852583,
      0.385956,
      1.172559,
      1,
      1,
      1,
      0.118120,
      NULL,
      0.114311,
      0.771664,
      NULL,
      5.144765,
      2.550673,
      1.172257,
      6.290468,
      1,
      6,
      5,
      NULL,
      NULL,
      2,
      1,
      1,
      1.639250,
      0.658464,
      5,
      3,
      8,
      3.700735,
      8,
      6,
      11,
      5,
      1.808289,
      6.019054,
      6,
      1,
      0.131693,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077656,
      1.283999,
      0,
      2,
      0.632016,
      NULL,
      1.066068,
      1.996598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.190063,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.660806,
      0,
      0.592255,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443443,
      4,
      NULL,
      1.134637,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.847485,
      NULL,
      1.430561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.064590,
      NULL,
      1.652892,
      2,
      3.726434,
      NULL,
      0,
      0.359448,
      0.581789,
      0.090769,
      1.253985,
      NULL,
      1.022487,
      1,
      NULL,
      0.510947,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '41140',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


