set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      NULL,
      4.008588,
      NULL,
      '3421321',
      118,
      1,
      1,
      2,
      NULL,
      4,
      NULL,
      7,
      NULL,
      1.335073,
      NULL,
      NULL,
      1,
      1.569296,
      1.104750,
      0.727135,
      0.675519,
      1.102197,
      1,
      0,
      0.394924,
      NULL,
      NULL,
      NULL,
      1.259996,
      2.765852,
      0,
      NULL,
      4.931484,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      3.468214,
      0.085320,
      1,
      1,
      NULL,
      NULL,
      1.223555,
      NULL,
      NULL,
      8.597133,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2,
      1,
      NULL,
      1.187881,
      3,
      0.959211,
      0,
      NULL,
      1.727478,
      NULL,
      1.499266,
      0,
      0,
      0.304940,
      1,
      NULL,
      1,
      2,
      0.719473,
      0.345585,
      NULL,
      NULL,
      1.875490,
      NULL,
      NULL,
      NULL,
      1.568227,
      NULL,
      0,
      3.505967,
      4,
      3.819289,
      0.355537,
      1.733269,
      1.268671,
      0,
      1,
      0,
      3.568697,
      0.700126,
      0.174199,
      NULL,
      0.761485,
      0,
      NULL,
      1,
      0.105340,
      NULL,
      NULL,
      3,
      1.466796,
      2.249367,
      0,
      3,
      5.501206,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      1,
      9,
      2.740790,
      9.800493,
      3,
      4.777704,
      NULL,
      2.280129,
      9,
      7,
      5.906878,
      2.045142,
      2,
      NULL,
      1.736359,
      1.112644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.181916,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4.472064,
      6,
      0,
      1,
      1.531911,
      NULL,
      NULL,
      NULL,
      0.091064,
      8.676694,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.535154,
      1.567107,
      2,
      3.173278,
      2,
      1,
      0.958393,
      1,
      1,
      0,
      NULL,
      1.188951,
      0,
      0,
      0.582042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      NULL,
      '3442',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


