set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '44003103',
      27.163995,
      47,
      '0024412',
      204,
      6,
      NULL,
      0,
      '334331',
      NULL,
      ' 2-19-1974',
      54,
      17,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.555667,
      NULL,
      1,
      0,
      0,
      3,
      1.945295,
      NULL,
      0.209814,
      NULL,
      0,
      0.024263,
      1,
      5,
      2,
      0,
      3,
      0,
      2,
      3,
      1,
      1.960667,
      0,
      2,
      1.303035,
      NULL,
      NULL,
      0.329368,
      NULL,
      NULL,
      1,
      0,
      0.103415,
      2,
      NULL,
      NULL,
      3.432461,
      1.121246,
      1.980332,
      3.378845,
      1.517271,
      3,
      0,
      0.066317,
      1,
      1,
      NULL,
      1.231023,
      0,
      5,
      1,
      1,
      NULL,
      0,
      NULL,
      1.733659,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.155201,
      0,
      3,
      1,
      4,
      NULL,
      3.198087,
      1.177869,
      0,
      1,
      0.603163,
      NULL,
      0.531361,
      2.721053,
      NULL,
      0.458169,
      0.634849,
      1.054757,
      NULL,
      NULL,
      1.992466,
      6.682353,
      2.153602,
      1,
      NULL,
      0.961574,
      2.023370,
      0.901056,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048433,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.678711,
      1,
      4.599175,
      4.256792,
      NULL,
      2.131292,
      0.860672,
      2.802820,
      9.710914,
      NULL,
      1.600363,
      0,
      1.730546,
      NULL,
      0.508338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.052692,
      1,
      1,
      0.800530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.829436,
      NULL,
      0.876186,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      4.619734,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9.432480,
      1.916023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507195,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      2,
      1,
      1,
      1,
      1,
      1.704437,
      0,
      1.270832,
      0.188801,
      0,
      1.181665,
      0.950099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '11414',
      '',
      '',
      0,
      '',
      NULL,
      '',
      5.384410,
      NULL,
      '2443',
      '',
      NULL,
      1,
      0.332080,
      0,
      1,
      3.435259,
      2.804048,
      NULL,
      1);
commit;
end;
/


