set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42431032',
      44.241709,
      18,
      '2203243',
      4.449190,
      5,
      1.802658,
      3,
      '233122',
      0.149319,
      ' 3-13-1975',
      34.688811,
      63,
      NULL,
      NULL,
      0,
      1.170797,
      0.367805,
      0.052320,
      1,
      1.685200,
      NULL,
      0.452284,
      NULL,
      0.501812,
      1,
      1.633497,
      1,
      NULL,
      5,
      NULL,
      5.623066,
      1.261966,
      1,
      1,
      NULL,
      1.589787,
      2,
      NULL,
      0.624743,
      1,
      1.967442,
      0.147879,
      NULL,
      NULL,
      0.221347,
      NULL,
      NULL,
      3,
      1,
      3.528703,
      2,
      NULL,
      1,
      2,
      1.469026,
      NULL,
      NULL,
      NULL,
      0.109255,
      0.339620,
      3.302293,
      1.842456,
      1,
      NULL,
      1,
      0.936153,
      4,
      1.653915,
      0,
      4,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      0.177263,
      NULL,
      NULL,
      0.807320,
      NULL,
      NULL,
      0.808738,
      1.431929,
      NULL,
      1.062357,
      1,
      1.503654,
      1,
      0,
      0,
      0.858371,
      3.515433,
      0,
      NULL,
      0.287731,
      1.829347,
      0,
      NULL,
      1.237857,
      4,
      3.919850,
      0,
      1.646090,
      NULL,
      6,
      0,
      NULL,
      1.839323,
      3,
      1,
      NULL,
      0,
      1,
      1.731232,
      1,
      0.317840,
      6,
      6.485176,
      NULL,
      6.641969,
      5,
      2.103812,
      5,
      4.246803,
      10.027460,
      9.030291,
      2,
      0,
      0.994175,
      0.844891,
      1.120884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.666750,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772622,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.945919,
      1.549817,
      2,
      2,
      0,
      1,
      1.042456,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720567,
      3.334938,
      1.323437,
      NULL,
      1,
      3,
      0.561920,
      NULL,
      NULL,
      3.309191,
      1,
      0.660312,
      0,
      1.873897,
      0,
      0.781306,
      1.003792,
      1.016207,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294327,
      '22012',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '22300',
      NULL,
      '',
      5.662665,
      2.770101,
      2.281946,
      NULL,
      1,
      0.578862,
      3,
      2.334099,
      0.089486);
commit;
end;
/


