set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41023012',
      51,
      NULL,
      '3022211',
      176,
      0,
      0,
      1,
      '024343',
      NULL,
      '11-25-1978',
      54.358089,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.385058,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0.990101,
      NULL,
      1,
      0.665307,
      6,
      0.834017,
      6.049106,
      NULL,
      5.523168,
      0.265894,
      NULL,
      1.317786,
      1,
      0,
      0,
      2.294021,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.229684,
      0,
      0.030249,
      NULL,
      1.564726,
      NULL,
      3,
      0,
      1.973917,
      NULL,
      NULL,
      1.821642,
      0.083616,
      NULL,
      2.479295,
      1.977322,
      1,
      1,
      NULL,
      NULL,
      0,
      9.010341,
      0,
      0,
      1.936315,
      0.951360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.261616,
      1.110217,
      3,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.298052,
      3.365094,
      1,
      NULL,
      1.820913,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5.172597,
      0.523464,
      2,
      0,
      4.661485,
      0.614048,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      2.577350,
      3.731357,
      2,
      6.513453,
      1.979713,
      3,
      8,
      1,
      NULL,
      6,
      NULL,
      2,
      1,
      0.552136,
      3,
      0.491429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615088,
      1.176349,
      NULL,
      1,
      0,
      NULL,
      0.197325,
      0.600942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.271070,
      5.244418,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.709142,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      1.837160,
      0,
      1.578913,
      1.156828,
      1,
      1.240392,
      1,
      1.417227,
      0,
      0.175781,
      1.834128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '24134',
      '',
      '',
      1.450810,
      '',
      '',
      '',
      0.909558,
      NULL,
      '3101',
      '',
      3,
      0,
      2,
      4,
      2,
      NULL,
      2,
      0,
      2.385837);
commit;
end;
/


