set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '21411301',
      7.935280,
      NULL,
      '0220212',
      178,
      0,
      2,
      1,
      '222221',
      NULL,
      ' 7-27-1977',
      20,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.477486,
      NULL,
      0.307592,
      2.124366,
      0,
      1,
      1.245142,
      0.490918,
      NULL,
      NULL,
      1,
      0,
      0.994370,
      0.324907,
      7.662828,
      NULL,
      3,
      1.251766,
      0,
      0.935354,
      0.212438,
      1,
      4,
      1,
      3.813184,
      0.752553,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.714466,
      0,
      0,
      1,
      0.382783,
      2,
      2,
      NULL,
      1.350514,
      1,
      2,
      1,
      NULL,
      0,
      0,
      1.236771,
      1,
      1.946030,
      0,
      5,
      1,
      1,
      1,
      1.629676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340318,
      1.536871,
      1,
      0.915408,
      NULL,
      1.611414,
      0.697827,
      1.344442,
      1.145601,
      0.916355,
      0,
      1,
      NULL,
      1,
      1.376559,
      0.306258,
      0.837705,
      NULL,
      0,
      NULL,
      1.282776,
      4,
      1,
      0.289927,
      1.808709,
      0,
      1,
      0.271011,
      0.638188,
      3,
      2.988541,
      1,
      NULL,
      1,
      0.534570,
      0.984331,
      NULL,
      4.992678,
      0,
      7.545361,
      NULL,
      9,
      0,
      5.094175,
      5,
      7.688830,
      NULL,
      8,
      3,
      0,
      1,
      NULL,
      0.975991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574707,
      1,
      1,
      2,
      1.442787,
      1.447711,
      1.762279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959695,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547793,
      NULL,
      NULL,
      NULL,
      NULL,
      5.029529,
      0.832250,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.471767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.710736,
      1.742906,
      3.513139,
      3,
      2,
      0,
      0.518500,
      0.750044,
      2.558136,
      0,
      1.424763,
      0.276942,
      NULL,
      NULL,
      NULL,
      1.134802,
      1,
      0.878022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.970152,
      '21414',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '4331',
      '',
      5.141765,
      1.872656,
      2,
      2,
      3.259271,
      1.932131,
      NULL,
      3.296228,
      1.822271);
commit;
end;
/


