set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '13140414',
      0,
      55.639602,
      '3030411',
      211,
      2,
      0,
      1,
      '342122',
      1,
      '11-18-1986',
      NULL,
      20.906576,
      0.937525,
      NULL,
      0,
      0,
      1.583921,
      NULL,
      0.408010,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0.290089,
      1.239621,
      7,
      7.943885,
      3,
      0.438212,
      NULL,
      1.451094,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.236111,
      NULL,
      0.127242,
      1.877044,
      1.159405,
      0.211441,
      3,
      NULL,
      0,
      2.774340,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      0.065617,
      4.927017,
      1.863272,
      0.193019,
      3,
      1,
      NULL,
      0.130030,
      0.309849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550015,
      1.858627,
      1,
      0,
      1,
      NULL,
      2,
      1.857758,
      1.289256,
      NULL,
      1.582682,
      1,
      1,
      0.024834,
      1.972855,
      0,
      1.768024,
      1,
      1.719775,
      NULL,
      NULL,
      NULL,
      6,
      0.235703,
      NULL,
      1,
      5,
      1,
      NULL,
      0.002916,
      0,
      NULL,
      0.321222,
      0,
      0,
      NULL,
      1.549222,
      0,
      4.898876,
      2.207744,
      4.570114,
      NULL,
      1.050299,
      8.294588,
      8.174267,
      3.138482,
      2,
      4,
      0,
      1.368715,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035677,
      1,
      1,
      1,
      NULL,
      1.450977,
      1.931046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452820,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784342,
      1,
      NULL,
      NULL,
      NULL,
      0.759410,
      5.726016,
      6,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.826413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.689634,
      1,
      3.150485,
      NULL,
      0,
      3.372085,
      1.018813,
      1,
      0.671725,
      1,
      NULL,
      0,
      0,
      1.044463,
      NULL,
      0.536558,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.107081,
      '13141',
      NULL,
      '2133',
      NULL,
      2,
      NULL,
      5.328714,
      3.659029,
      3,
      2.840592,
      2,
      3.727779);
commit;
end;
/


