set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '42024320',
      18,
      72,
      '2214432',
      10,
      5,
      NULL,
      3,
      NULL,
      5.676469,
      ' 8- 6-1989',
      NULL,
      25.569170,
      0.332613,
      NULL,
      7,
      1.232864,
      3.043565,
      0,
      NULL,
      NULL,
      1.813445,
      NULL,
      0,
      1.301252,
      1.483619,
      NULL,
      0,
      6,
      NULL,
      1,
      4,
      NULL,
      0,
      0.149961,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.076335,
      2.265154,
      0.995655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.535023,
      2,
      1.346315,
      0,
      NULL,
      0,
      1.096556,
      3,
      0.717677,
      3.448630,
      0,
      0.855112,
      1.297162,
      2,
      0,
      0.798722,
      0,
      5.867123,
      3,
      1.682991,
      NULL,
      1,
      2,
      1.758376,
      1,
      NULL,
      NULL,
      1.290642,
      NULL,
      NULL,
      0,
      1.099700,
      1,
      0.261357,
      1.450100,
      0.274848,
      3,
      1,
      1,
      1,
      NULL,
      1,
      1.625805,
      2.506860,
      1,
      1.843972,
      1,
      0,
      1.016582,
      NULL,
      1.150221,
      1.604328,
      NULL,
      0.247424,
      NULL,
      1.319072,
      NULL,
      NULL,
      0,
      0.013131,
      1,
      NULL,
      0,
      0,
      1.289536,
      NULL,
      1,
      1.137112,
      3,
      7,
      9.348136,
      7.384475,
      1,
      9.868689,
      NULL,
      2,
      1.749932,
      NULL,
      3,
      0.850415,
      0,
      2.209185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735589,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2.148751,
      NULL,
      5,
      1,
      0,
      NULL,
      1.864050,
      NULL,
      NULL,
      NULL,
      NULL,
      3.320869,
      0.394727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.270960,
      1.448863,
      1.118175,
      1,
      3.507507,
      0.904244,
      1,
      0.619363,
      1,
      NULL,
      1,
      0.415720,
      1.687805,
      NULL,
      NULL,
      0.722418,
      0.175035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '40221',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      6,
      NULL,
      '0331',
      '0003',
      NULL,
      1.266352,
      2.971706,
      5,
      NULL,
      0.943306,
      NULL,
      1.533126,
      0);
commit;
end;
/


