set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '21223212',
      NULL,
      64.286050,
      '0224443',
      NULL,
      NULL,
      1,
      2,
      '313213',
      3,
      ' 7- 8-1995',
      8,
      52,
      0.541424,
      NULL,
      0,
      NULL,
      0.319447,
      0,
      0,
      1.560598,
      0,
      0,
      0,
      0.640865,
      1.303140,
      NULL,
      1,
      NULL,
      0,
      1.366787,
      3.645479,
      NULL,
      1.495180,
      1.558923,
      1.390437,
      0,
      6.968565,
      1,
      1.892426,
      3,
      3.718857,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      1.787525,
      1.177629,
      1,
      1,
      1.578276,
      3.319733,
      1,
      1.549833,
      0,
      2,
      0.664068,
      1.616147,
      NULL,
      2.985290,
      1,
      0,
      NULL,
      5.214512,
      NULL,
      NULL,
      6.696251,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.934804,
      0,
      1.864557,
      0.729332,
      NULL,
      2.611941,
      1.757089,
      1,
      1.981193,
      0,
      1.608641,
      1,
      1.978385,
      2.103813,
      1,
      0.494220,
      0,
      0,
      0.526293,
      NULL,
      0.715697,
      NULL,
      7.865772,
      NULL,
      NULL,
      1,
      NULL,
      0.640811,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653942,
      1,
      1.173916,
      0.760236,
      0,
      1.538568,
      6.689240,
      1,
      7.308030,
      4,
      5,
      9.532433,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.648001,
      NULL,
      6.831842,
      1.590575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.714680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.655983,
      NULL,
      NULL,
      NULL,
      5,
      4.159634,
      5.461084,
      5,
      1.916475,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.404517,
      1.960805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911399,
      NULL,
      0,
      1,
      3,
      0.192986,
      3,
      0,
      1.059822,
      2.013966,
      1,
      1.196187,
      0,
      0,
      0,
      1,
      0.113943,
      0,
      1.393798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '24030',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '0242',
      '2410',
      4.050607,
      NULL,
      2.496857,
      2,
      2,
      2,
      2,
      1.064485,
      0);
commit;
end;
/


