set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '43303311',
      33.100675,
      NULL,
      '4030440',
      57,
      3,
      1.173336,
      1,
      '441040',
      4,
      ' 4-26-1988',
      26,
      7,
      1.784923,
      NULL,
      6,
      0,
      0,
      1,
      0.954110,
      2.644022,
      NULL,
      NULL,
      NULL,
      1.761884,
      0,
      0.619899,
      1.936988,
      4.655075,
      7.352049,
      NULL,
      NULL,
      0.046541,
      0,
      1,
      0.142320,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      0.775063,
      NULL,
      NULL,
      1.997271,
      NULL,
      NULL,
      2.785675,
      0,
      3,
      2.275406,
      1,
      1,
      3,
      1.395081,
      2,
      0.575695,
      NULL,
      NULL,
      1,
      2.539511,
      0.207129,
      3,
      NULL,
      1.753445,
      NULL,
      1.854452,
      1.753015,
      1.350999,
      NULL,
      0,
      1,
      0.589340,
      0,
      NULL,
      NULL,
      0.943462,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.763930,
      0.592978,
      1,
      1,
      0.261626,
      1,
      NULL,
      1.927192,
      0.792181,
      1.034541,
      3,
      0,
      0,
      0,
      1,
      1.987119,
      NULL,
      NULL,
      2.165350,
      NULL,
      1.751894,
      3.786886,
      1,
      7,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1.502449,
      NULL,
      NULL,
      1.058316,
      7,
      2.554761,
      NULL,
      0,
      7,
      1,
      3,
      6,
      1,
      8,
      2.160132,
      1.149416,
      0.491900,
      0.848464,
      NULL,
      0.218869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203134,
      1.389035,
      1,
      2,
      1.226391,
      1,
      0.185454,
      0.879817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.191678,
      5.536644,
      4,
      0,
      0.305036,
      NULL,
      1.872972,
      NULL,
      NULL,
      NULL,
      1.423851,
      3.172355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863105,
      3,
      0.467066,
      2,
      2,
      NULL,
      1.903989,
      1.628019,
      0,
      0.570816,
      1,
      NULL,
      0.281254,
      NULL,
      1.278075,
      1.986708,
      0.755228,
      1.467508,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.020142,
      '13003',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.300388,
      '42144',
      '1443',
      '3322',
      0,
      NULL,
      2,
      5,
      0.975606,
      0,
      0,
      3,
      1.147125);
commit;
end;
/


