set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2430',
      '01040142',
      71.444749,
      72,
      NULL,
      182.869799,
      0,
      0,
      0,
      '313413',
      NULL,
      ' 0- 4-1984',
      24.992005,
      1,
      1,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      1.913336,
      0.406981,
      0.297893,
      1,
      1,
      5.230038,
      5,
      NULL,
      NULL,
      1,
      0.378104,
      1.234618,
      NULL,
      0.077215,
      0.339368,
      0,
      0,
      1.149041,
      0.073267,
      1,
      NULL,
      NULL,
      0.141253,
      NULL,
      NULL,
      7.662357,
      2,
      2.240794,
      3,
      1,
      0,
      2,
      1.004798,
      NULL,
      3,
      1.813314,
      0.630198,
      1,
      NULL,
      1.855405,
      0.676395,
      NULL,
      0,
      1,
      1,
      0.030003,
      1,
      7.490950,
      0,
      0,
      NULL,
      1.769207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.561315,
      1.049307,
      1.781362,
      0.500019,
      NULL,
      1.087561,
      NULL,
      NULL,
      0.916622,
      1.207451,
      0.888201,
      0.797787,
      1.358239,
      3,
      NULL,
      1,
      0.073548,
      NULL,
      NULL,
      NULL,
      0.784247,
      1.426217,
      6,
      NULL,
      2.494398,
      0,
      3.592886,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032894,
      0,
      1,
      1,
      1.742829,
      1.945474,
      NULL,
      4,
      NULL,
      0,
      2.816920,
      9.312926,
      7.288066,
      NULL,
      0,
      3,
      0.840879,
      NULL,
      1.607795,
      8.446925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927757,
      0,
      0,
      NULL,
      1.640199,
      0.673930,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610299,
      2.026268,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4.465793,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.467039,
      0.996054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      1.716791,
      1.069947,
      0,
      0,
      1.020110,
      1,
      NULL,
      NULL,
      1,
      1.174983,
      0.458791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '44332',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '2001',
      2.740727,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      3);
commit;
end;
/


