set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2410',
      '43420042',
      51.901483,
      10.067863,
      '1102333',
      263,
      3,
      0,
      3,
      '204024',
      0,
      ' 5- 2-1975',
      8,
      52,
      0,
      NULL,
      NULL,
      0.044301,
      0.474819,
      1.286303,
      1,
      2,
      0,
      0,
      1.512966,
      1.035426,
      2,
      1.444070,
      0,
      NULL,
      NULL,
      1.229369,
      5,
      1.117190,
      1.898130,
      1.057408,
      1.937762,
      1,
      5.473089,
      NULL,
      NULL,
      0.147914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200489,
      NULL,
      0,
      1,
      1,
      3.038903,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.509037,
      1,
      0,
      0,
      7.077324,
      1.520929,
      NULL,
      4,
      0,
      1,
      0.316866,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.049278,
      0,
      0.086234,
      1,
      0,
      NULL,
      1.843413,
      0,
      1.243678,
      1,
      0,
      0.217980,
      0.314783,
      NULL,
      0.348466,
      1.721165,
      1.055250,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143181,
      1.200579,
      4.007045,
      1,
      6,
      1,
      1,
      1,
      0.069742,
      NULL,
      1,
      1,
      0,
      1,
      1.505832,
      2.561117,
      6,
      NULL,
      NULL,
      9,
      NULL,
      1.959448,
      4.557221,
      2,
      5.023606,
      2,
      3.807482,
      0.848428,
      0.090268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.966423,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276553,
      NULL,
      0.336292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.247620,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.002979,
      3,
      3.475016,
      0.618866,
      NULL,
      0.191742,
      1.564764,
      0.148820,
      NULL,
      0.899216,
      0.903400,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1.615469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.164746,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      7,
      '32221',
      '1112',
      NULL,
      NULL,
      1,
      0,
      5.810631,
      0,
      0.057332,
      2,
      2.838940,
      2);
commit;
end;
/


