set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4413',
      '44234402',
      19,
      27.594498,
      '2131024',
      168.531908,
      0,
      1,
      1,
      '020420',
      3,
      NULL,
      27,
      14.840568,
      1,
      NULL,
      6,
      0,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.018535,
      1.933937,
      5.506225,
      0.505985,
      3,
      NULL,
      0.790442,
      NULL,
      1,
      0.875507,
      0.349476,
      0,
      4,
      0,
      0.237894,
      NULL,
      NULL,
      NULL,
      1.554021,
      NULL,
      NULL,
      4.225986,
      2,
      1.930031,
      2,
      1,
      1.346991,
      2.486230,
      3.775021,
      NULL,
      NULL,
      1.093728,
      0,
      0.697586,
      0.908959,
      NULL,
      1.412008,
      1,
      1.249769,
      0.810315,
      5.381913,
      0.863714,
      0.805640,
      5.743592,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.248120,
      NULL,
      NULL,
      0.096665,
      1.693621,
      1.435924,
      NULL,
      1,
      0.667428,
      1,
      0.218209,
      1,
      1,
      1.553477,
      0.558901,
      1.797232,
      0.005833,
      NULL,
      1.844355,
      0,
      NULL,
      1,
      NULL,
      1,
      1.388871,
      NULL,
      1,
      1.521887,
      1.510045,
      2.006490,
      0,
      0,
      1,
      1.875873,
      NULL,
      0.459843,
      NULL,
      0,
      1,
      NULL,
      4,
      0.348760,
      7.070356,
      4.230910,
      11.349649,
      2,
      8.219475,
      3.452280,
      0,
      4,
      0,
      NULL,
      1.678382,
      NULL,
      5,
      0.542207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.799903,
      0.395584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216268,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943361,
      1.967869,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1.608675,
      7.545846,
      0.841799,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.339183,
      2,
      3.127748,
      2,
      1,
      0.552581,
      2,
      1,
      0,
      NULL,
      NULL,
      0.349282,
      0.040988,
      0,
      NULL,
      1.520486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11110',
      '',
      '',
      0,
      '',
      '',
      '',
      6.101358,
      NULL,
      '2224',
      '0341',
      4,
      1.961840,
      2,
      4,
      NULL,
      3,
      5.983129,
      NULL,
      2.973021);
commit;
end;
/


