set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '21',
      5,
      17,
      '3442224',
      2,
      3,
      3.662449,
      2,
      '331110',
      1.669091,
      ' 3- 6-1989',
      10.222493,
      37.013668,
      1.422067,
      NULL,
      NULL,
      0,
      3.792440,
      1,
      NULL,
      2,
      0.134177,
      1,
      3.078635,
      0.212571,
      5.664618,
      1.648344,
      NULL,
      0.490900,
      1.625827,
      0,
      NULL,
      0,
      0.128724,
      NULL,
      2,
      1.470975,
      NULL,
      0,
      3.854289,
      0.584207,
      1.136894,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324609,
      1,
      3,
      2.621118,
      1.132634,
      1,
      2,
      1,
      NULL,
      1,
      1.379226,
      1.274062,
      0,
      1.191651,
      1,
      0.906767,
      1.149000,
      1.003501,
      0.070401,
      NULL,
      0,
      0,
      4.181268,
      0,
      NULL,
      0.560141,
      0,
      NULL,
      NULL,
      0.888506,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145976,
      0,
      5.864870,
      0,
      1.731800,
      1.190211,
      0,
      NULL,
      0.858615,
      0.658750,
      1.472678,
      NULL,
      0.939588,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      7,
      0.574391,
      1,
      NULL,
      1,
      4,
      1.600329,
      6.166814,
      3.876417,
      2.572139,
      3,
      8,
      2.946579,
      5,
      1.128658,
      NULL,
      1,
      2.710266,
      5,
      3.751510,
      2.376044,
      3,
      9,
      9.285903,
      1.862249,
      NULL,
      2.226451,
      NULL,
      0,
      1.343412,
      2.011184,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.940739,
      1.433573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0.613779,
      2.944047,
      1.471025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.850910,
      0,
      0,
      0.106303,
      3,
      3.456350,
      0.562866,
      NULL,
      3.806151,
      NULL,
      6,
      NULL,
      0.831538,
      NULL,
      NULL,
      NULL,
      NULL,
      9.387110,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223047,
      NULL,
      2.674956,
      1.842516,
      NULL,
      3,
      0,
      3.945999,
      NULL,
      3,
      NULL,
      0.970289,
      1.480157,
      0,
      0.526741,
      1.459784,
      1.864768,
      0.465595,
      1.985642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '31023',
      '04000',
      '',
      1,
      NULL,
      '',
      NULL,
      1.466220,
      '',
      '',
      '',
      4.912568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


