set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      NULL,
      4.036928,
      NULL,
      '2121203',
      20.613300,
      3,
      2,
      3,
      '043100',
      5,
      '11-17-1975',
      NULL,
      43,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.818913,
      0,
      2.001194,
      NULL,
      1,
      3,
      0.220971,
      2,
      0,
      2,
      4,
      1,
      0,
      5.973697,
      1,
      0,
      1,
      NULL,
      3.021048,
      7,
      1,
      5.149412,
      3,
      3.227267,
      0.887556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.563225,
      1,
      0.686673,
      0,
      2,
      NULL,
      0,
      0,
      1.190265,
      NULL,
      NULL,
      1.243825,
      0.911632,
      2.974408,
      0.522190,
      0.561884,
      1,
      1,
      1,
      0,
      0,
      0,
      6.434465,
      0,
      2,
      1.955406,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.754456,
      1.891704,
      0.904804,
      1,
      1.293283,
      5.577262,
      NULL,
      0,
      0.203543,
      NULL,
      1.856373,
      NULL,
      0.313932,
      5.943669,
      0,
      NULL,
      1,
      1.394388,
      1,
      NULL,
      NULL,
      2.765211,
      NULL,
      1,
      0.032844,
      1.419863,
      1,
      0,
      3.842507,
      0.212548,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0.514288,
      1.853667,
      7,
      NULL,
      1.404517,
      2.759765,
      6.642213,
      NULL,
      8,
      5,
      3,
      NULL,
      2,
      2,
      1,
      1,
      0.407579,
      0.744613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150050,
      1,
      0,
      1,
      1.907363,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793371,
      NULL,
      9,
      1.954701,
      2.302979,
      2.889653,
      1.493693,
      1.460108,
      NULL,
      0.437060,
      3,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1.100350,
      NULL,
      0,
      1.514828,
      NULL,
      NULL,
      NULL,
      0,
      3.944108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725121,
      1,
      NULL,
      0.303254,
      1,
      0.059525,
      NULL,
      NULL,
      1.655298,
      1,
      1.689175,
      1.246450,
      0.251425,
      0.423582,
      0.127672,
      1,
      0.434158,
      0.873770,
      0.408014,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.066740,
      '11432',
      '12302',
      NULL,
      0.425094,
      '',
      '',
      NULL,
      0.340840,
      NULL,
      '',
      '',
      3.244457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


