set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '22',
      35.168992,
      16.129913,
      '2333232',
      NULL,
      NULL,
      NULL,
      0,
      '420333',
      2,
      NULL,
      5.575438,
      62,
      1.739522,
      NULL,
      1.047373,
      0.402881,
      NULL,
      1.460011,
      1.983232,
      2,
      1.126882,
      1,
      0,
      0.124261,
      4,
      0.258988,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      2.307601,
      0,
      1.514823,
      5,
      4.834305,
      1,
      NULL,
      0.410561,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.898040,
      NULL,
      1.234671,
      2,
      1,
      0,
      0,
      1.579733,
      NULL,
      1,
      3.360360,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.334700,
      0.727972,
      0.086920,
      6.233834,
      0,
      2,
      1.920022,
      1.456509,
      NULL,
      NULL,
      0.978319,
      NULL,
      NULL,
      NULL,
      1.498889,
      3.619101,
      1,
      1,
      2,
      NULL,
      0.466918,
      NULL,
      0,
      0.435982,
      NULL,
      0,
      0.988111,
      0,
      1.504415,
      0,
      1,
      1.768464,
      NULL,
      0.447149,
      4,
      2,
      1.776639,
      0.238336,
      1.790638,
      4,
      1,
      3.891239,
      3.544839,
      1,
      3.292159,
      0,
      0,
      1.358266,
      1,
      3.213377,
      4.759880,
      1.359505,
      3.443603,
      6,
      6,
      8.897041,
      8.287317,
      1,
      1,
      0,
      2,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.738367,
      0,
      1.297859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.008471,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.835377,
      0,
      0,
      4.520216,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.928408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.872773,
      3,
      NULL,
      NULL,
      1.257480,
      0,
      2.396333,
      2.323167,
      0.467078,
      0.671440,
      1,
      1,
      0.177731,
      0,
      NULL,
      1,
      1.247443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.704149,
      '01241',
      '01321',
      NULL,
      0.809912,
      '',
      '',
      '',
      2.099539,
      '3141',
      NULL,
      '',
      0.045765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


