set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '33',
      55,
      9,
      '0220022',
      NULL,
      0,
      3.873237,
      NULL,
      '001044',
      0.114352,
      '10-26-1976',
      12,
      36.194726,
      1,
      NULL,
      1,
      NULL,
      0.883091,
      0.440995,
      NULL,
      2,
      0.768775,
      NULL,
      3.964300,
      1.079356,
      1.354155,
      0.980135,
      3,
      4.046192,
      NULL,
      NULL,
      NULL,
      3.513192,
      3,
      0.979007,
      NULL,
      3,
      3.539587,
      0,
      3.039108,
      0,
      3,
      0,
      NULL,
      NULL,
      0.622647,
      NULL,
      NULL,
      3.061435,
      1.652324,
      NULL,
      3.966131,
      1,
      0.395585,
      1,
      0,
      2,
      NULL,
      2.960390,
      0,
      3.711271,
      3.615080,
      2,
      NULL,
      1,
      1,
      1.903319,
      3,
      1,
      1,
      6.909406,
      1,
      2,
      1.209704,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.418972,
      0,
      1.602225,
      5,
      NULL,
      0.659696,
      0,
      1.695211,
      NULL,
      NULL,
      0.927285,
      NULL,
      NULL,
      0.096729,
      0.343964,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1.589208,
      1,
      0.560998,
      0,
      3.619072,
      1,
      1.936154,
      0.089270,
      0.253355,
      4,
      1.940522,
      0.327033,
      4,
      4,
      9.386469,
      7,
      3.247990,
      NULL,
      7.401304,
      NULL,
      2.712539,
      1.237043,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.291150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188440,
      1.434993,
      0,
      1,
      0.194430,
      0.143972,
      1,
      1.196920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      3.074630,
      2.455272,
      1.898404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.908087,
      NULL,
      NULL,
      NULL,
      1.895321,
      0,
      1.055339,
      4,
      2.498948,
      1,
      2.087423,
      NULL,
      NULL,
      NULL,
      0.991686,
      10.910675,
      0.545337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380557,
      3.196538,
      NULL,
      0.635165,
      3,
      0.660457,
      3,
      NULL,
      1,
      2.641090,
      NULL,
      1.823299,
      0.696196,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24402',
      '40214',
      '',
      1.117668,
      NULL,
      '',
      '',
      1,
      '2423',
      '',
      '',
      1,
      5,
      NULL,
      1.017375,
      2,
      1.284351,
      1.320939,
      2,
      NULL);
commit;
end;
/


