set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '24013121',
      35.108502,
      NULL,
      '2424022',
      7.890807,
      6,
      0,
      0,
      '202043',
      4.142519,
      NULL,
      42.202513,
      45,
      0.175406,
      NULL,
      0,
      3.764496,
      1.651336,
      0.678676,
      NULL,
      0.062142,
      1.627897,
      NULL,
      2.808900,
      0,
      4,
      1.397491,
      6.407237,
      7,
      5,
      1,
      4.581297,
      NULL,
      0.126789,
      3,
      1,
      0,
      3.903959,
      1,
      0.596237,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008025,
      NULL,
      1,
      0.620226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.667431,
      0,
      0.513135,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.617853,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      2,
      NULL,
      5,
      0.242105,
      0,
      5.602415,
      1.053380,
      0,
      0.704624,
      1.608724,
      0.902143,
      NULL,
      1.549319,
      1.338149,
      1,
      NULL,
      1,
      1.319517,
      2.936494,
      NULL,
      3,
      NULL,
      1.665157,
      0,
      NULL,
      2,
      4.245723,
      2,
      0,
      1,
      2,
      0,
      5,
      0.562722,
      1.441142,
      2,
      2,
      2.072096,
      3,
      9.088779,
      1,
      2.803909,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.711090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203356,
      1.673269,
      0,
      1,
      0,
      1.608648,
      1,
      0.197865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.323336,
      1.309425,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.080801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.975724,
      1,
      3.164155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938813,
      1,
      1.650745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.357938,
      3,
      1,
      NULL,
      2,
      1,
      2.752860,
      NULL,
      1,
      NULL,
      0.063376,
      NULL,
      1.643337,
      NULL,
      0,
      0,
      1.554383,
      0,
      0.205046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.429231,
      '24013',
      '44111',
      '',
      0,
      NULL,
      '',
      '',
      0.930252,
      '1442',
      '0430',
      '',
      3,
      1.704485,
      1.865621,
      3,
      0.095808,
      2,
      1.655565,
      2.534354,
      2.220511);
commit;
end;
/


