set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '14323311',
      0,
      14.203270,
      '2144404',
      65,
      2,
      0.493042,
      1,
      '031303',
      1,
      NULL,
      43,
      61.927370,
      1,
      NULL,
      0,
      0,
      0.962960,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681653,
      0.944210,
      7,
      1.244159,
      4,
      NULL,
      3,
      1.359023,
      4.790638,
      0.234530,
      1,
      3,
      0.431709,
      0,
      6,
      0,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376043,
      0,
      2.628349,
      0.425389,
      NULL,
      3,
      0,
      1,
      0,
      1.909055,
      NULL,
      0,
      2.068257,
      NULL,
      0.210600,
      1.542752,
      1.764340,
      NULL,
      0,
      NULL,
      1,
      3.145972,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.675379,
      NULL,
      NULL,
      1.066493,
      0.563804,
      NULL,
      0.373879,
      5,
      3.419751,
      NULL,
      1.808684,
      0,
      5,
      0,
      NULL,
      1,
      2,
      0.213870,
      0,
      1.055762,
      NULL,
      1.923785,
      NULL,
      0.995184,
      0,
      5,
      NULL,
      NULL,
      0,
      2.347221,
      1.508208,
      4.981374,
      NULL,
      1.121397,
      3.737083,
      NULL,
      1.545259,
      NULL,
      1.482804,
      9.011084,
      2,
      0,
      3,
      7.357851,
      6.409727,
      NULL,
      1.437335,
      2.419460,
      3.067389,
      NULL,
      5,
      1.566358,
      0.311442,
      NULL,
      1,
      1.480332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564012,
      NULL,
      0,
      0.569451,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.539396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.163712,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940554,
      0.000766,
      0.981966,
      3,
      1,
      1,
      2.331340,
      1.029776,
      NULL,
      NULL,
      0.416840,
      10.900928,
      0.390669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639693,
      1.854539,
      3.257848,
      1,
      2,
      3,
      NULL,
      NULL,
      0.484977,
      2.190188,
      1.589956,
      0.780058,
      1,
      1.657880,
      1,
      1.426009,
      1,
      0.192219,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '20243',
      '32230',
      '',
      1,
      '',
      '',
      '',
      5.620040,
      '2413',
      NULL,
      '',
      5,
      NULL,
      1,
      1,
      1.383719,
      1.821918,
      2,
      0,
      0);
commit;
end;
/


