set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      13.537060,
      45.023274,
      '0141121',
      NULL,
      NULL,
      3,
      0,
      '010202',
      0.691838,
      ' 5-18-1975',
      NULL,
      45.798667,
      1.212347,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0.655614,
      0,
      NULL,
      NULL,
      3.392120,
      0,
      6,
      5,
      3.638132,
      1.573070,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      7,
      NULL,
      0.283753,
      1,
      0.173294,
      NULL,
      NULL,
      NULL,
      0.372077,
      NULL,
      NULL,
      5,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.655197,
      0,
      5,
      1,
      2,
      0.365838,
      1.892541,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      0.176282,
      0,
      1,
      1,
      0,
      0,
      3,
      1,
      0.207887,
      1,
      3.994314,
      NULL,
      NULL,
      1.266835,
      0.489927,
      1,
      NULL,
      0,
      3,
      0.860932,
      1,
      1.488314,
      1.593205,
      3,
      0.014543,
      3.572164,
      NULL,
      2,
      0.225990,
      2.461580,
      0.840957,
      0.490980,
      0,
      NULL,
      NULL,
      9.741082,
      7.389582,
      NULL,
      NULL,
      7.748403,
      10,
      9,
      2,
      0.417305,
      3.155854,
      0.152510,
      1.295069,
      1.480410,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768878,
      0,
      NULL,
      2,
      1.406941,
      1,
      0,
      1.522894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.783919,
      NULL,
      0.192412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.736043,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.548980,
      2,
      3,
      2,
      1,
      6.123448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.457978,
      1.475721,
      1.062340,
      3,
      3,
      2.193383,
      1.280081,
      0.414275,
      0.788826,
      3.231583,
      0,
      NULL,
      1.714284,
      1.405452,
      1,
      1,
      NULL,
      1,
      0.634386,
      1.835810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '10433',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      4.428993,
      '4330',
      '3102',
      '',
      0,
      5,
      0.762413,
      2.467170,
      0.756382,
      1,
      1.946782,
      1,
      2);
commit;
end;
/


