set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10131111',
      NULL,
      NULL,
      '4311203',
      NULL,
      5,
      2.516644,
      2,
      '131343',
      2,
      ' 6- 1-1976',
      NULL,
      NULL,
      0,
      NULL,
      1.539826,
      1.145398,
      0.936171,
      1.115060,
      0.753225,
      1,
      0.261645,
      1.271171,
      0.246784,
      1.758727,
      NULL,
      NULL,
      2,
      4.414901,
      0,
      1,
      NULL,
      0.720004,
      0.942193,
      NULL,
      0,
      1.626636,
      NULL,
      0,
      1.970843,
      1.157011,
      NULL,
      0,
      NULL,
      NULL,
      1.187938,
      NULL,
      NULL,
      0.684907,
      3.304845,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      2,
      1,
      NULL,
      0,
      1.164007,
      NULL,
      NULL,
      0.768519,
      NULL,
      NULL,
      0.911886,
      0,
      4.429208,
      1.707789,
      0,
      0,
      0.018175,
      1,
      1,
      1.986812,
      1,
      0.499130,
      1.394411,
      1.478191,
      0,
      0.851690,
      0.501872,
      0,
      1,
      NULL,
      0,
      2,
      0.668199,
      1,
      3.061969,
      0,
      3,
      3.605628,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      1,
      NULL,
      3.771362,
      NULL,
      0.293719,
      1,
      2,
      0.639400,
      10.428351,
      2.299953,
      4.641434,
      1,
      5.592912,
      3.916630,
      0.043399,
      0,
      2.592560,
      1.441923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1.388686,
      0.464714,
      1.869127,
      0.559164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.579703,
      0.913806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334032,
      1,
      NULL,
      NULL,
      NULL,
      1.146092,
      1,
      3,
      4,
      2.278515,
      0,
      0.353872,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657607,
      0,
      NULL,
      NULL,
      1.160935,
      2,
      3,
      1,
      1,
      3.791664,
      NULL,
      0,
      0,
      1.432073,
      0.857169,
      0,
      1.209436,
      0,
      1.098559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '24234',
      NULL,
      NULL,
      0.102622,
      '',
      '',
      '',
      NULL,
      '1101',
      '0333',
      NULL,
      3,
      4.294753,
      0,
      NULL,
      2.734408,
      NULL,
      0,
      NULL,
      1.036179);
commit;
end;
/


