set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '31020344',
      35.260303,
      5.332783,
      '0022432',
      62,
      5,
      3.183731,
      NULL,
      '244012',
      4.995162,
      ' 3-26-1979',
      41.750985,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.374594,
      1.989814,
      0.345408,
      1,
      0.082163,
      1,
      3,
      0.377211,
      NULL,
      NULL,
      5.506197,
      0,
      0,
      NULL,
      6.329819,
      0.129682,
      1,
      0.429712,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.550250,
      1.658122,
      NULL,
      NULL,
      1,
      1,
      5,
      4.220295,
      1.567672,
      0,
      NULL,
      0.169639,
      0,
      NULL,
      1,
      NULL,
      1,
      0.235569,
      0.142117,
      0,
      0.996990,
      NULL,
      0,
      NULL,
      0.358111,
      0,
      NULL,
      0.036047,
      0,
      5.778807,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      4,
      0.132770,
      NULL,
      0.415752,
      6.752173,
      NULL,
      3.200218,
      NULL,
      0,
      0.197878,
      0.416022,
      0,
      5,
      1,
      NULL,
      0.206497,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.111859,
      0.947345,
      4.150691,
      1.819144,
      NULL,
      NULL,
      NULL,
      NULL,
      6.939480,
      0,
      5,
      0.848980,
      5.900556,
      3,
      0.706066,
      10.043257,
      NULL,
      9,
      7.062951,
      9.505179,
      10,
      6,
      1.643010,
      0.543774,
      1.377925,
      NULL,
      0,
      5.003723,
      0.701043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080687,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.849356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.262966,
      NULL,
      3,
      1,
      2.865788,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989588,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.884079,
      5.577471,
      6,
      0,
      NULL,
      2.341903,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.990361,
      0,
      6.363138,
      7.438253,
      NULL,
      1,
      3,
      NULL,
      0,
      0.949271,
      1,
      1,
      0,
      3,
      NULL,
      2.644507,
      2,
      1.246933,
      1.168940,
      NULL,
      NULL,
      1.172069,
      0.869379,
      NULL,
      0.790767,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.702369,
      '12412',
      '20314',
      NULL,
      1.837668,
      NULL,
      '',
      '',
      4,
      '3020',
      '2401',
      '',
      4,
      2.829614,
      0.959533,
      NULL,
      NULL,
      0,
      1,
      1.703422,
      2);
commit;
end;
/


