set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '03014102',
      64.093902,
      NULL,
      '1001133',
      68,
      NULL,
      3,
      2,
      '234211',
      1,
      NULL,
      40,
      53.720738,
      1.914607,
      NULL,
      2,
      NULL,
      1.040497,
      1.598158,
      1,
      NULL,
      0.123775,
      0.050348,
      2,
      1,
      0,
      0,
      4.973236,
      5.923133,
      NULL,
      2.331309,
      3,
      0,
      2.929190,
      2.622509,
      NULL,
      1,
      4,
      1,
      5.925377,
      3,
      NULL,
      0.600610,
      NULL,
      NULL,
      1.482660,
      1.806248,
      NULL,
      10,
      0,
      1.743171,
      1,
      0,
      1,
      2,
      1.859269,
      0,
      NULL,
      0.768555,
      NULL,
      3,
      0.394208,
      2,
      0.835728,
      0.899090,
      0,
      1,
      1,
      1,
      1.848368,
      NULL,
      NULL,
      0,
      1,
      0.246961,
      NULL,
      NULL,
      1.349583,
      2.113555,
      1,
      0.442703,
      NULL,
      8,
      NULL,
      NULL,
      1,
      5.312289,
      0.441146,
      0.988419,
      1.632701,
      1,
      1,
      1.092021,
      NULL,
      1.813425,
      0,
      0.160518,
      0.911284,
      1.931378,
      NULL,
      0,
      0.136951,
      0.212474,
      0,
      3.073778,
      0,
      1.869006,
      0.478963,
      NULL,
      NULL,
      3,
      1.495540,
      5,
      1.291735,
      3,
      1,
      2.663957,
      NULL,
      NULL,
      9.381487,
      8,
      8,
      NULL,
      5,
      1.116718,
      5.211694,
      4,
      4,
      NULL,
      0.547351,
      1.615155,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420016,
      1,
      1,
      1,
      1,
      0,
      0.859835,
      0.036098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.679452,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.280019,
      NULL,
      0,
      0.812412,
      NULL,
      2.796348,
      0.740186,
      0.781639,
      1,
      NULL,
      NULL,
      NULL,
      1.707605,
      1.351042,
      NULL,
      NULL,
      3.006241,
      5,
      NULL,
      NULL,
      5,
      6,
      3,
      1,
      1.301609,
      2.256062,
      2.938514,
      2.344243,
      1,
      1,
      3.505210,
      1.508757,
      1.761343,
      0.362757,
      NULL,
      3.777098,
      1,
      1,
      0,
      0,
      0.011411,
      0,
      0.857927,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '33421',
      '04103',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '2140',
      '2411',
      '1104',
      0,
      NULL,
      3,
      3,
      3,
      0.362939,
      NULL,
      4.183334,
      NULL);
commit;
end;
/


