set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '01131124',
      45.685707,
      1.891418,
      NULL,
      51.729147,
      6,
      2.942120,
      0,
      '402210',
      4.538702,
      ' 2-25-1988',
      51,
      NULL,
      0,
      NULL,
      2.498502,
      1.484107,
      1,
      0.967823,
      1,
      0.964609,
      1.086894,
      0,
      1,
      1,
      0,
      0.456533,
      0,
      0,
      1.054404,
      4,
      2.003778,
      NULL,
      1,
      0.019469,
      1,
      0,
      6.139723,
      0,
      NULL,
      2,
      NULL,
      1.246935,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.180769,
      NULL,
      0,
      0.232833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854621,
      0.831709,
      1.860678,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      2.171110,
      1.159731,
      1,
      1,
      0.532714,
      1.638839,
      NULL,
      1.101526,
      0.220979,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.263356,
      1.722316,
      1,
      NULL,
      3.094764,
      0,
      1.459601,
      NULL,
      NULL,
      3,
      6,
      2.437752,
      2.224489,
      0,
      3,
      1.312606,
      2,
      4,
      9,
      NULL,
      NULL,
      2,
      7,
      3,
      7.384885,
      5,
      1.567766,
      1,
      1.182212,
      1,
      1.982044,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.194379,
      1,
      NULL,
      0.084229,
      1,
      1,
      1.410222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.437401,
      NULL,
      9,
      1.095315,
      0,
      0.358555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.836322,
      NULL,
      NULL,
      NULL,
      0,
      0.423622,
      1.932207,
      5,
      0,
      0,
      2.528713,
      NULL,
      NULL,
      NULL,
      1.069624,
      4.261023,
      0.317630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.995411,
      1.199548,
      0.959796,
      0.414236,
      1,
      1.647708,
      1,
      1,
      1.118651,
      NULL,
      0,
      0.302193,
      1,
      1.504005,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44144',
      '04202',
      NULL,
      1.366718,
      '',
      '',
      '',
      NULL,
      '4231',
      '4244',
      '1213',
      NULL,
      7,
      0.101165,
      1.183694,
      0,
      0,
      NULL,
      5,
      0);
commit;
end;
/


