set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '40132330',
      13.215981,
      47.197999,
      '4441204',
      101.064063,
      2,
      0.433792,
      3,
      '203433',
      1,
      NULL,
      22.170647,
      NULL,
      0.558443,
      NULL,
      1,
      0.030155,
      NULL,
      1,
      0.419195,
      1,
      1.820784,
      0.385648,
      0.624908,
      NULL,
      4,
      NULL,
      5.598824,
      NULL,
      3.194746,
      1,
      NULL,
      3.583290,
      3,
      3.619857,
      3.629398,
      NULL,
      1,
      1,
      5,
      1,
      1.681932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.105714,
      1,
      1,
      2,
      1.251695,
      0,
      3,
      3.423786,
      0.421238,
      1,
      NULL,
      0.015995,
      0.005890,
      2,
      NULL,
      NULL,
      0,
      1.002801,
      0,
      0,
      3,
      1.359323,
      5,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.649499,
      NULL,
      0,
      4.680606,
      1.141472,
      0.065004,
      NULL,
      0,
      1.257456,
      0,
      0,
      1,
      1.623680,
      0,
      0.121465,
      1,
      1.973975,
      0.812696,
      NULL,
      0.043353,
      2,
      1.839346,
      0.362639,
      0,
      0.711935,
      NULL,
      1.365447,
      3,
      NULL,
      1,
      5.894297,
      NULL,
      NULL,
      1,
      1,
      3.772712,
      NULL,
      5.577344,
      9.967954,
      11,
      NULL,
      NULL,
      8,
      4,
      3.834200,
      0,
      0,
      0.924302,
      0,
      1.061599,
      4.297005,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537202,
      NULL,
      1,
      2,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209839,
      NULL,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.255309,
      1,
      NULL,
      NULL,
      NULL,
      3.693986,
      0.216920,
      NULL,
      9,
      3,
      2,
      0.545894,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1.658060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.910967,
      0,
      1,
      1,
      NULL,
      0,
      1,
      2,
      0.258775,
      NULL,
      1,
      0,
      0.162429,
      0.106759,
      NULL,
      0,
      1.073668,
      1.538009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '01211',
      '31104',
      '',
      1,
      '',
      '',
      '',
      6.178445,
      '1213',
      '3312',
      '3241',
      5,
      0,
      1.319676,
      0.877495,
      1,
      3.368291,
      2,
      2.104408,
      3);
commit;
end;
/


