set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2312',
      NULL,
      25,
      62,
      '0122420',
      77,
      NULL,
      3.335602,
      1,
      '000314',
      2,
      ' 0-16-1990',
      NULL,
      14.431177,
      0,
      NULL,
      4,
      NULL,
      0.603424,
      1,
      1.463694,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.054266,
      6.885253,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.857292,
      2.388877,
      NULL,
      6.644365,
      0,
      3,
      0,
      NULL,
      0.792795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.958598,
      1,
      3,
      0,
      0,
      0,
      0,
      NULL,
      0.585206,
      1.124152,
      NULL,
      0.705084,
      0,
      3.453157,
      0,
      3.660014,
      0,
      NULL,
      1,
      5.155265,
      0.235591,
      5.403067,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.192904,
      NULL,
      NULL,
      2.566252,
      0.362346,
      NULL,
      1.215761,
      5.843218,
      2.253049,
      7.372084,
      0.276125,
      NULL,
      1,
      0.329385,
      1.294505,
      NULL,
      3.721033,
      0.079511,
      0,
      NULL,
      NULL,
      1.383311,
      NULL,
      1,
      5.996721,
      3,
      0.445554,
      3.833894,
      1,
      0.776232,
      0.830722,
      NULL,
      NULL,
      7,
      0,
      0,
      0,
      5.695209,
      1,
      3,
      2.159602,
      8.126575,
      9.955537,
      2.684360,
      0,
      8.818465,
      8,
      NULL,
      NULL,
      1.032275,
      5,
      NULL,
      0,
      NULL,
      1.174135,
      0.136275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.917674,
      NULL,
      7,
      0,
      3,
      6,
      NULL,
      2,
      0.856891,
      0,
      4.419818,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631438,
      6.863602,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362185,
      1.695688,
      1.588816,
      NULL,
      0.058576,
      2,
      0.344753,
      0.831227,
      0,
      3,
      3.778881,
      0,
      0,
      0.502424,
      0.325526,
      0.386589,
      1,
      1.480852,
      NULL,
      1.139892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.111540,
      '22212',
      '10404',
      '',
      0.089564,
      '',
      '',
      '',
      1.053429,
      '2004',
      '3423',
      '0033',
      0.478666,
      6.673713,
      3,
      0.997412,
      0,
      0.213216,
      2,
      3.609505,
      2);
commit;
end;
/


