set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2340',
      '30434303',
      66.939098,
      81,
      '2042230',
      NULL,
      6,
      1.869896,
      3,
      '434304',
      5,
      NULL,
      50.342615,
      19.380276,
      0.443149,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      1,
      0,
      0.060671,
      0.767140,
      5.670285,
      0,
      3.992262,
      NULL,
      NULL,
      4.816614,
      2,
      0,
      0.786199,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      3,
      1,
      0.500253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.268520,
      1,
      0,
      0,
      1.559437,
      NULL,
      2,
      2,
      0,
      1.301033,
      0,
      1,
      2.609083,
      3.663616,
      2.672314,
      0,
      NULL,
      0,
      1.199228,
      NULL,
      1.535227,
      3.098371,
      1,
      1,
      1.726548,
      0,
      NULL,
      NULL,
      1.576737,
      NULL,
      NULL,
      1.480316,
      1,
      1.850241,
      1.365105,
      2.403635,
      5.744195,
      NULL,
      NULL,
      1,
      1.866142,
      0,
      0.884130,
      1,
      5.157070,
      0,
      0,
      1.156865,
      0,
      0.801676,
      NULL,
      1,
      NULL,
      NULL,
      0.416043,
      2.363334,
      1,
      3.143284,
      1,
      1.716168,
      3.797140,
      0.158184,
      4.305767,
      2.675394,
      0.800864,
      2.268297,
      1.260037,
      4.663945,
      NULL,
      1,
      8.662030,
      0,
      7.515019,
      1.023805,
      5,
      NULL,
      5,
      1.460358,
      0,
      0.202863,
      NULL,
      0.459172,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.988514,
      0.989421,
      2,
      0.141811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.111646,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.535839,
      NULL,
      NULL,
      NULL,
      NULL,
      4.466014,
      1.906029,
      7.274862,
      3.128131,
      4.541137,
      2,
      0.392047,
      NULL,
      NULL,
      NULL,
      0.015178,
      5.057853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.936330,
      1,
      NULL,
      0,
      NULL,
      0.274636,
      0,
      2,
      0,
      0,
      1.756334,
      NULL,
      1,
      0.574705,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.934191,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '1402',
      '2222',
      1.152478,
      NULL,
      NULL,
      4,
      2.688749,
      NULL,
      0.549530,
      2,
      2);
commit;
end;
/


