set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3030',
      '23433121',
      72.629041,
      86,
      NULL,
      12,
      2,
      2,
      0,
      NULL,
      0.697349,
      ' 7- 9-1976',
      20.614331,
      53.533943,
      0,
      NULL,
      0.414988,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0.898586,
      NULL,
      1.021085,
      6.948221,
      1.856219,
      5,
      1.073107,
      1,
      NULL,
      1,
      2,
      3.731986,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      0,
      1.028669,
      NULL,
      NULL,
      1.019043,
      NULL,
      NULL,
      2.435240,
      0.606431,
      0,
      0.216965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.191439,
      0.455282,
      4.506716,
      0,
      0,
      1.411989,
      0,
      NULL,
      NULL,
      0.228661,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      1,
      5.312555,
      NULL,
      1,
      1.702988,
      1,
      NULL,
      1.615318,
      1.159868,
      0.171985,
      0.048555,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      0,
      3,
      1,
      NULL,
      0.558667,
      NULL,
      3.139924,
      3.282084,
      0,
      4,
      NULL,
      1,
      NULL,
      4,
      4,
      4,
      5,
      0,
      0.948230,
      4,
      NULL,
      4.060387,
      4.619285,
      1.623990,
      0,
      3,
      0.823012,
      0.119180,
      0.005625,
      0.860396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876281,
      NULL,
      0,
      0.089830,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312703,
      NULL,
      2,
      1.590623,
      0,
      0.278597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.317502,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.173709,
      2,
      NULL,
      NULL,
      0,
      1.604649,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      2.318430,
      0.203725,
      3.259392,
      3,
      1.272364,
      NULL,
      0.129290,
      NULL,
      0.134529,
      1.778932,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '24231',
      '22101',
      '',
      1,
      '',
      '',
      '',
      4,
      '1143',
      '1430',
      '4331',
      2.202781,
      3.735850,
      1.245620,
      1,
      3.017164,
      0.567403,
      NULL,
      3.800734,
      4.348711);
commit;
end;
/


