set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2303',
      '41420110',
      10,
      45,
      '2144332',
      101.828132,
      1,
      1,
      1,
      '414041',
      4,
      ' 7-10-1982',
      37.565934,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109114,
      1,
      1,
      NULL,
      0.843525,
      0,
      NULL,
      NULL,
      1.169940,
      7,
      1.734703,
      5,
      5.283762,
      0,
      5,
      NULL,
      0,
      NULL,
      3,
      2,
      1.347027,
      1,
      1,
      1.702185,
      3,
      NULL,
      0.296630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.523046,
      0,
      0.842655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.547498,
      NULL,
      0,
      1,
      1.769828,
      0.692942,
      NULL,
      NULL,
      1.001622,
      NULL,
      NULL,
      1,
      3.754830,
      0,
      0,
      5,
      3,
      5.487744,
      1.870969,
      1,
      1.874169,
      1,
      0,
      0.180264,
      2,
      NULL,
      0.978369,
      1,
      1,
      0.041205,
      NULL,
      0.178509,
      3.979318,
      NULL,
      0,
      1,
      2.562503,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.686067,
      6.049834,
      1,
      8.795440,
      8,
      4.641680,
      9.410916,
      8.392851,
      9.527844,
      8,
      3,
      9,
      2.716405,
      1.956676,
      3,
      2,
      1,
      1.869513,
      1.331976,
      1.571441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.226754,
      0,
      0.408457,
      0.843287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.503871,
      2,
      4.200128,
      0,
      NULL,
      0.922811,
      NULL,
      2.015801,
      NULL,
      1.064082,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.084350,
      NULL,
      5.014839,
      NULL,
      NULL,
      3,
      1.502386,
      NULL,
      NULL,
      1.778710,
      11.118699,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.271308,
      NULL,
      3.262085,
      2.484222,
      0,
      3,
      NULL,
      3.582695,
      1,
      0.887031,
      NULL,
      0,
      NULL,
      1.635227,
      0,
      1.579505,
      1.137768,
      1.556947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.603027,
      NULL,
      '21111',
      NULL,
      NULL,
      NULL,
      '',
      '',
      3.758629,
      '3313',
      '0122',
      '0420',
      0,
      7.335377,
      0,
      0.971761,
      0,
      0,
      0.773551,
      0.717239,
      2.580345);
commit;
end;
/


