set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10',
      34.628987,
      2,
      '1120344',
      NULL,
      1,
      NULL,
      3,
      '212110',
      4.903926,
      ' 0-22-1979',
      20.284901,
      24,
      1,
      NULL,
      1,
      2.539042,
      0,
      1.196236,
      0.864327,
      NULL,
      NULL,
      1,
      1.530340,
      NULL,
      NULL,
      1,
      11.531813,
      NULL,
      NULL,
      3.072779,
      11,
      1.663341,
      NULL,
      NULL,
      3,
      3,
      6,
      3,
      4,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.059312,
      NULL,
      NULL,
      9.566865,
      NULL,
      NULL,
      NULL,
      0,
      0.860379,
      NULL,
      1.671687,
      0,
      NULL,
      0.513004,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      5,
      0.160638,
      1.431943,
      NULL,
      3,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.179138,
      1,
      1,
      2.703043,
      9.178395,
      3.245991,
      3.910658,
      NULL,
      1.313802,
      NULL,
      NULL,
      0,
      1,
      1.680240,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.229965,
      NULL,
      NULL,
      2.564476,
      0.081025,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      0,
      7.229068,
      NULL,
      9,
      7,
      5,
      4.562831,
      6,
      2.997400,
      NULL,
      5,
      NULL,
      2.821097,
      NULL,
      3.239244,
      1.781800,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703791,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.893654,
      NULL,
      NULL,
      0,
      3.547018,
      2,
      1.684878,
      1.777441,
      2,
      2.153629,
      3,
      2,
      0.869998,
      1.163845,
      2,
      2.133140,
      NULL,
      1,
      9.019984,
      2.534001,
      3,
      3.668349,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.956675,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.922589,
      0.815917,
      NULL,
      3,
      1,
      1.915689,
      1,
      0,
      0,
      1,
      0,
      1.925768,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02110',
      '23442',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      3,
      2.326843,
      NULL,
      2,
      2,
      1.499529,
      0.149416,
      2.668311);
commit;
end;
/


