set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      1,
      6,
      2.545533,
      0,
      '012242',
      NULL,
      ' 4-15-1982',
      15.366498,
      NULL,
      0,
      NULL,
      2.313340,
      NULL,
      0,
      0,
      2,
      1.145492,
      3,
      NULL,
      0.422121,
      0,
      1.992646,
      NULL,
      0.443542,
      0,
      NULL,
      NULL,
      1.815508,
      1.687344,
      0.743832,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      0.145807,
      1,
      0.920313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244108,
      0,
      0,
      2,
      1.070731,
      0,
      0.556617,
      1,
      1.833918,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      3.931447,
      2,
      2.316872,
      1,
      1.551678,
      NULL,
      NULL,
      1,
      2,
      1,
      1.262581,
      NULL,
      NULL,
      0.990432,
      NULL,
      NULL,
      0.677935,
      2.401264,
      3.935017,
      0.279342,
      4.384539,
      1,
      0.986106,
      0.904198,
      1.595398,
      0.868019,
      0,
      1.767648,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.074823,
      NULL,
      1.441109,
      2,
      1,
      1.287267,
      0,
      1,
      0.052385,
      1,
      1.204850,
      0,
      0.762756,
      0.336405,
      NULL,
      1.768413,
      2.725832,
      NULL,
      2,
      3.436176,
      7.597869,
      NULL,
      1.747279,
      1,
      2,
      7.429881,
      6.431665,
      0.276983,
      0.967328,
      2,
      2,
      1,
      1.556494,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801057,
      0,
      1,
      0,
      0,
      1.399848,
      0,
      0.501641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.892011,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.878398,
      4.215784,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.898981,
      NULL,
      0.317801,
      1,
      NULL,
      1,
      2,
      NULL,
      3.858646,
      NULL,
      1,
      0,
      NULL,
      0,
      1.843402,
      1,
      0.819632,
      0.415310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.252454,
      '10344',
      '',
      NULL,
      0.240727,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


