set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      22.419924,
      NULL,
      0,
      3,
      '222020',
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0.089388,
      NULL,
      NULL,
      3,
      1,
      3.336103,
      1.854876,
      0,
      0.863985,
      NULL,
      NULL,
      0.769029,
      0,
      1,
      1,
      4.959875,
      0,
      1,
      1,
      0,
      1,
      2.514357,
      0,
      4,
      2.867831,
      NULL,
      1.822950,
      NULL,
      NULL,
      0.462925,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1.513309,
      0.561135,
      NULL,
      1.779978,
      0.625394,
      0,
      2.858124,
      2.741045,
      0,
      3.779171,
      NULL,
      0,
      1,
      1.358737,
      1.306622,
      1,
      NULL,
      0,
      1.836262,
      NULL,
      NULL,
      2,
      2.153763,
      1.881605,
      NULL,
      NULL,
      0.913721,
      NULL,
      NULL,
      0.738718,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.095981,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      3.079826,
      0.639084,
      0,
      1,
      NULL,
      1,
      0,
      1,
      2.039828,
      NULL,
      2,
      0,
      4,
      4.521603,
      NULL,
      1.420566,
      6.721896,
      9,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2.986206,
      NULL,
      1,
      0,
      NULL,
      0.076395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.876345,
      0,
      0,
      1.335083,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0.503720,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.486169,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.165118,
      1,
      1,
      1,
      2,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      0.139274,
      NULL,
      0,
      0,
      0.391862,
      0,
      1.104085,
      1.848988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.325099,
      '23231',
      '',
      '',
      0.950288,
      '',
      '',
      '',
      1.353947,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


