set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      49,
      54.756261,
      '3043100',
      NULL,
      0,
      0,
      0,
      '404212',
      NULL,
      '10-14-2003',
      110.829585,
      153.485713,
      1.805830,
      NULL,
      1,
      1,
      2,
      0,
      1,
      0.888054,
      1.541157,
      3,
      0,
      1.946192,
      4.070649,
      NULL,
      0.328165,
      1.371219,
      1,
      1,
      0,
      0.153745,
      0.058467,
      0,
      0.734294,
      1.832752,
      4,
      0,
      2,
      1.179030,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.608027,
      0,
      NULL,
      0.928039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.945215,
      0,
      1.583143,
      NULL,
      0,
      0,
      1.324577,
      1.291610,
      1,
      0.525737,
      1.502071,
      0.539948,
      0,
      0.254524,
      NULL,
      NULL,
      1.527838,
      NULL,
      0,
      0.485912,
      NULL,
      1.667601,
      0.213413,
      NULL,
      NULL,
      0,
      1,
      5,
      1.827402,
      3.781736,
      7,
      NULL,
      NULL,
      2,
      7.639067,
      1,
      NULL,
      1,
      1,
      NULL,
      5,
      1.685034,
      NULL,
      1.351358,
      0,
      0.081209,
      1.005232,
      4.504711,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.889955,
      0,
      1,
      1.278804,
      0,
      1,
      1.240594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271447,
      NULL,
      NULL,
      NULL,
      NULL,
      4.398658,
      0,
      0,
      0,
      1.780605,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275118,
      0.889673,
      1,
      NULL,
      1.017759,
      2,
      0.807375,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574430,
      0,
      0.960264,
      1,
      0,
      0,
      2,
      NULL,
      0,
      1.951753,
      3,
      0.159978,
      0.799228,
      1.270807,
      NULL,
      1.610306,
      0.856819,
      1.645459,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.478919,
      '23102',
      '',
      '',
      1.675702,
      NULL,
      '',
      '',
      0.270792,
      '',
      '',
      NULL,
      2.674619,
      0,
      1,
      0,
      2,
      1,
      3.752115,
      3,
      1);
commit;
end;
/


