set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2113',
      '23012030',
      46,
      NULL,
      NULL,
      4.194506,
      1,
      3.382423,
      2,
      '210112',
      3.417862,
      ' 0-12-1998',
      104,
      58,
      0.234065,
      NULL,
      2.814019,
      NULL,
      1,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      1.352138,
      0,
      0,
      1.062273,
      0,
      0.660402,
      NULL,
      NULL,
      0,
      0.902342,
      NULL,
      0.999561,
      0,
      8,
      0,
      NULL,
      1.397950,
      NULL,
      0.002473,
      NULL,
      NULL,
      0.484399,
      NULL,
      NULL,
      1.464720,
      1,
      0.667642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782605,
      0.291203,
      1,
      0.353263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.811169,
      NULL,
      1.941573,
      3,
      NULL,
      NULL,
      NULL,
      1.307732,
      1.583086,
      0.043238,
      NULL,
      1.613556,
      1.702091,
      0.621737,
      NULL,
      1.189596,
      0,
      1,
      NULL,
      0,
      1,
      1.980139,
      0.674234,
      1,
      1,
      0,
      1.227655,
      5,
      1,
      1,
      1,
      5.348576,
      NULL,
      4.460729,
      0,
      1,
      9.522219,
      NULL,
      0,
      9,
      NULL,
      7.391658,
      7.762738,
      9,
      0,
      1.261751,
      1.939494,
      3.281144,
      0,
      0.404908,
      0.498268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274819,
      0.717511,
      2,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850893,
      NULL,
      NULL,
      NULL,
      NULL,
      3.529397,
      0,
      0,
      1.103197,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.128885,
      0.092362,
      9,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7.388778,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.830303,
      1,
      1.831605,
      3,
      1.968734,
      1.405259,
      NULL,
      1,
      3.236954,
      0.912076,
      0.202665,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      2.995896,
      4,
      0.122531,
      5.714508,
      2.836703,
      1.417646,
      NULL,
      3.748831,
      0.359251);
commit;
end;
/


