set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1402',
      '34142001',
      NULL,
      43.998569,
      NULL,
      NULL,
      6,
      1.504583,
      0,
      '313403',
      3,
      NULL,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988320,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.937219,
      NULL,
      1,
      0.804369,
      0,
      NULL,
      0,
      1,
      0.886432,
      1,
      0,
      0,
      1.996284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.737307,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075123,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.820167,
      NULL,
      1,
      NULL,
      2.797577,
      1.742226,
      1.569016,
      1.729863,
      1,
      5,
      NULL,
      7.425116,
      0.236725,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.318500,
      0.979414,
      NULL,
      1,
      0,
      1,
      1.642031,
      3.739089,
      1,
      1,
      0,
      0,
      4,
      0,
      1,
      NULL,
      NULL,
      4,
      2,
      6,
      NULL,
      2,
      4.124992,
      5,
      0,
      0.977129,
      NULL,
      0.797838,
      0.067285,
      0,
      0.844233,
      1.748579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.772746,
      1.449530,
      NULL,
      1.642985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.120611,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.678358,
      NULL,
      7.679582,
      0.025130,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088701,
      0.922068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015247,
      NULL,
      0.330449,
      1,
      0,
      0,
      3,
      0,
      NULL,
      1.501907,
      1.083771,
      0,
      0.898948,
      0.415210,
      NULL,
      0,
      0.774287,
      0,
      NULL,
      1.415543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.123094,
      '22340',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.512395,
      '',
      NULL,
      '',
      3,
      0.842774,
      2,
      1.700216,
      3,
      NULL,
      1.419708,
      1,
      3);
commit;
end;
/


