set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '13',
      NULL,
      40,
      '4012442',
      92,
      4,
      3,
      1,
      '422130',
      2.546473,
      ' 2-29-1987',
      28,
      69.656421,
      1.913368,
      NULL,
      0.840141,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.172299,
      NULL,
      0.380349,
      7.070690,
      0.431228,
      1.904017,
      0,
      1.089729,
      1.146971,
      6,
      1,
      NULL,
      4,
      0,
      0.928387,
      6.786113,
      NULL,
      1.559645,
      1,
      1.727176,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.778851,
      0.524867,
      NULL,
      1,
      0.925374,
      0,
      2.994971,
      2.649449,
      1,
      2.268398,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      3.067273,
      0,
      1,
      1,
      2.957867,
      1,
      1,
      1.953041,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.242457,
      1,
      7,
      1.870101,
      3,
      NULL,
      1,
      1,
      NULL,
      1.442289,
      1.880209,
      1.027590,
      0.181335,
      0,
      1.766711,
      1,
      NULL,
      0.281362,
      1.012639,
      NULL,
      1,
      1.828754,
      0.328501,
      0.868572,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.173843,
      NULL,
      0.548132,
      0,
      5,
      1,
      1.705483,
      0.866385,
      NULL,
      8.849351,
      3.312384,
      3.764802,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.174892,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.103404,
      NULL,
      NULL,
      NULL,
      NULL,
      3.802668,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.336497,
      1,
      0.806173,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560899,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0.686881,
      1.191646,
      3,
      1.444568,
      1,
      1.413984,
      0.771637,
      0,
      1,
      0,
      0.664651,
      0.512981,
      1,
      1,
      0.575910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055726,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.393505,
      0,
      NULL,
      NULL,
      0,
      1.425224,
      2,
      3,
      '40042',
      '',
      '',
      1.470142,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      9.468989,
      1.474429,
      0,
      1.124481,
      NULL,
      1.928334,
      2.094802,
      3);
commit;
end;
/


