set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '12403330',
      21.761661,
      30,
      '2303144',
      58,
      1,
      1,
      NULL,
      '234344',
      0,
      ' 9-14-1989',
      37.010657,
      NULL,
      0.396152,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0.803323,
      0,
      3,
      1.826347,
      1,
      NULL,
      NULL,
      0,
      0,
      1.633577,
      3,
      5,
      1,
      1.172439,
      1.977928,
      NULL,
      NULL,
      5,
      0,
      1.469613,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922842,
      NULL,
      NULL,
      NULL,
      0.018772,
      1.267092,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162734,
      1.271359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457572,
      NULL,
      1,
      NULL,
      3.955016,
      NULL,
      1.557529,
      1.136667,
      0,
      1.971598,
      NULL,
      1.721357,
      NULL,
      1,
      0.197571,
      1,
      1.938928,
      NULL,
      1.443195,
      NULL,
      0.661954,
      0.969615,
      1.084607,
      2.880558,
      1,
      2,
      NULL,
      0.266672,
      0.442765,
      0,
      NULL,
      1.267515,
      1.396110,
      0,
      1,
      0.202044,
      0.653398,
      3.871664,
      2,
      1.206206,
      2.001587,
      5.482822,
      9.554003,
      NULL,
      7,
      2,
      0.326233,
      2.691191,
      0.467829,
      0,
      0.329510,
      4.351416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728025,
      1.587054,
      1,
      NULL,
      1,
      1,
      0.399392,
      0.664924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125600,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533094,
      2,
      2.801609,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.735201,
      3.414685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.092133,
      NULL,
      0,
      3.347081,
      2.246156,
      1,
      NULL,
      0.753392,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613062,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064597,
      1.495606,
      0,
      NULL,
      1.614618,
      0.024998,
      1,
      NULL,
      3.383197,
      '23331',
      NULL,
      '',
      0.706294,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      2,
      2.233025,
      1,
      2,
      1.207279,
      3.930068,
      3.946333);
commit;
end;
/


