set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1102',
      '12401112',
      81,
      22.166550,
      '3240042',
      NULL,
      2,
      0,
      NULL,
      '330320',
      NULL,
      NULL,
      NULL,
      15,
      0.234973,
      NULL,
      NULL,
      0.172347,
      0,
      NULL,
      NULL,
      1.962533,
      1.567039,
      2.100148,
      0,
      1,
      0,
      0.296697,
      NULL,
      1.590322,
      0,
      1,
      NULL,
      1,
      0,
      7,
      NULL,
      0,
      6,
      0,
      2.831743,
      2.009619,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.634106,
      1.495648,
      0,
      1.984588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435231,
      1.846056,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.659117,
      0,
      1,
      NULL,
      1.805473,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0.265520,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.443701,
      1,
      0.100614,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.653702,
      0,
      7,
      5,
      1.181033,
      NULL,
      NULL,
      NULL,
      6,
      2.051549,
      0.192956,
      0.493593,
      3,
      1.476350,
      0,
      1.418053,
      3.149245,
      1.233456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060309,
      1,
      1,
      NULL,
      1.023389,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.252296,
      2,
      3.866057,
      2.445245,
      NULL,
      0.890884,
      NULL,
      7,
      1.336893,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.895212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0.043761,
      2.479281,
      0.894383,
      3.909106,
      0.167039,
      0.062827,
      1.533304,
      0.233932,
      0.049197,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.254950,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.072112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603729,
      NULL,
      NULL,
      NULL,
      NULL,
      3.943399,
      NULL,
      0.687476,
      NULL,
      0.676964,
      1.969474,
      NULL,
      NULL,
      3,
      '02013',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      1,
      NULL,
      3.690918,
      NULL,
      3.863137,
      0.512829,
      1.644499,
      0.324860);
commit;
end;
/


