set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0033',
      '33441210',
      49.108249,
      37,
      '4303331',
      136,
      0,
      NULL,
      0,
      '343003',
      2.442714,
      NULL,
      44,
      6,
      0,
      NULL,
      1.369275,
      1.289928,
      2,
      1,
      1.313602,
      0,
      0,
      3,
      NULL,
      0.051385,
      2,
      0.778759,
      1.516715,
      1.272204,
      NULL,
      0,
      2,
      0.698628,
      5.468423,
      NULL,
      1,
      0,
      3.790515,
      1,
      0,
      1.748138,
      NULL,
      1.733208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.084679,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957222,
      0,
      0,
      1.509582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.013330,
      1.428237,
      NULL,
      1.238632,
      1.590048,
      0.300348,
      1,
      0.607474,
      NULL,
      0.515997,
      NULL,
      1,
      1.561118,
      1,
      1.611965,
      1.535576,
      0.568480,
      0.114038,
      NULL,
      1.223260,
      NULL,
      1,
      NULL,
      0,
      1.276550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284887,
      1,
      0,
      1,
      0,
      1,
      NULL,
      5.528840,
      1,
      4.136042,
      7,
      4.035424,
      0.235081,
      NULL,
      1,
      1.755007,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722525,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.188082,
      1,
      0,
      1.112036,
      1,
      2.287322,
      1.538322,
      NULL,
      NULL,
      0.426994,
      0.996560,
      NULL,
      1.176515,
      NULL,
      NULL,
      NULL,
      1,
      3.829238,
      0.899728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.140640,
      3,
      1,
      2,
      1,
      1,
      NULL,
      0,
      0.271876,
      NULL,
      NULL,
      NULL,
      1.897595,
      0,
      0.422857,
      NULL,
      NULL,
      1.940048,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '40032',
      '',
      '',
      1.741188,
      '',
      '',
      NULL,
      1.048285,
      '',
      '',
      '',
      NULL,
      0.551597,
      2.351235,
      2,
      3.067674,
      3,
      3.086068,
      0,
      3);
commit;
end;
/


