set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '4012443',
      NULL,
      3,
      NULL,
      3,
      '001422',
      3,
      ' 6-11-1985',
      50,
      NULL,
      0.265248,
      NULL,
      0,
      1,
      0,
      NULL,
      0.071971,
      0.990256,
      1,
      1,
      1.717949,
      0,
      0,
      NULL,
      1.938413,
      NULL,
      0,
      0.333730,
      0.457268,
      1,
      1.519642,
      3,
      NULL,
      NULL,
      NULL,
      0,
      4.705879,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.121653,
      0,
      3.701460,
      0,
      0,
      2.847058,
      0,
      NULL,
      0.634966,
      NULL,
      0,
      0.847321,
      1.173501,
      2,
      0,
      0.699110,
      0,
      0,
      0.252653,
      1.651918,
      0,
      4.031485,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670687,
      NULL,
      NULL,
      0.974769,
      1.511284,
      1,
      0,
      0,
      NULL,
      0.500675,
      0.171277,
      1,
      0,
      0,
      0,
      0.049618,
      0,
      1.258286,
      0,
      1.165653,
      1.157582,
      1,
      NULL,
      0.273149,
      NULL,
      0,
      NULL,
      5.938484,
      NULL,
      8.108586,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      8.663906,
      7.616060,
      0.797845,
      1.049481,
      0,
      0.714045,
      1,
      5.693897,
      2,
      3,
      4,
      0.058425,
      NULL,
      NULL,
      NULL,
      3.448880,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.698579,
      0.487319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.230053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.297253,
      2.415920,
      11,
      0.027389,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.126181,
      2.213137,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.150660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      3,
      0,
      1.291719,
      1,
      NULL,
      NULL,
      0.408838,
      1.771798,
      0,
      0,
      0,
      1.756108,
      1.516693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '42414',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


