set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '0330243',
      8,
      5,
      2,
      3,
      '213430',
      2,
      ' 5-25-1978',
      57,
      NULL,
      0.059380,
      NULL,
      NULL,
      1,
      3.605250,
      0,
      1.727844,
      2,
      1.400518,
      1,
      1.300590,
      0.665270,
      0.951199,
      NULL,
      1.301122,
      1.170379,
      NULL,
      1.126250,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050557,
      0,
      5.670535,
      1.229585,
      1,
      1,
      NULL,
      NULL,
      1.249543,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.990348,
      0,
      1,
      0,
      1.756757,
      3,
      1.285913,
      1,
      3,
      1,
      1,
      2.436811,
      0.957539,
      0,
      1.183336,
      0,
      1.419678,
      1,
      0,
      3.366654,
      0,
      0,
      1.231699,
      1.288415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.100136,
      NULL,
      3,
      4.726974,
      1,
      1,
      1.167682,
      0,
      0.393696,
      0.981383,
      NULL,
      0.567282,
      0,
      NULL,
      0.467170,
      0.404956,
      1,
      0.508773,
      NULL,
      1.987457,
      8.535642,
      1.611806,
      NULL,
      7,
      0.104073,
      NULL,
      1,
      2.047644,
      1,
      0.328738,
      0,
      1.445344,
      3.312098,
      6.483582,
      2,
      0,
      7.869018,
      1.153539,
      7.681492,
      3,
      0,
      5.482999,
      3.137349,
      NULL,
      5.120215,
      NULL,
      0.423761,
      3.679881,
      0,
      NULL,
      2,
      0.678824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      3.700111,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.193787,
      1.855358,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5.293024,
      2.231739,
      2.660747,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.493147,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      2.342786,
      1.822709,
      NULL,
      2.886896,
      3.155061,
      3.628234,
      NULL,
      0.663217,
      0.456566,
      0,
      0,
      1,
      0.604266,
      1.427635,
      1.341565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '34134',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


