set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0210220',
      NULL,
      NULL,
      2.309860,
      3,
      '203443',
      0,
      ' 5- 2-1988',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.195868,
      NULL,
      0,
      0.358197,
      NULL,
      0,
      3.805092,
      1,
      1,
      2,
      0.589752,
      0.925146,
      5,
      1,
      0.015993,
      1,
      1,
      0.534197,
      7.237397,
      0,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      1.142218,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.761361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.226934,
      3,
      NULL,
      1,
      0,
      NULL,
      1.709080,
      NULL,
      NULL,
      1.505322,
      NULL,
      NULL,
      0.166023,
      1,
      NULL,
      0.064124,
      5,
      NULL,
      5,
      1,
      NULL,
      1.662802,
      1.138262,
      NULL,
      1.722584,
      0,
      NULL,
      1.911533,
      1.291605,
      1,
      1,
      NULL,
      1,
      2,
      1.071127,
      NULL,
      NULL,
      0.537401,
      NULL,
      0.668223,
      7.656258,
      4,
      7,
      4,
      1.725385,
      NULL,
      4.081909,
      5.260196,
      1.177283,
      1,
      3,
      NULL,
      NULL,
      2,
      NULL,
      10,
      7,
      0,
      6.624305,
      1.626135,
      3.932176,
      1.565326,
      0,
      1.299352,
      0.615934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676030,
      NULL,
      NULL,
      NULL,
      NULL,
      5.325411,
      0.863327,
      1.805277,
      NULL,
      0,
      1,
      4.176819,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.890613,
      NULL,
      8.429171,
      5,
      NULL,
      NULL,
      3,
      0.542631,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.194108,
      NULL,
      1.980156,
      2.437003,
      3.025100,
      2.992061,
      NULL,
      1.820727,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1.427636,
      1.828117,
      0,
      0,
      1.099265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '10314',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


