set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '0331043',
      9.666270,
      3,
      2,
      2,
      '114442',
      0,
      NULL,
      23.323649,
      NULL,
      0.843969,
      NULL,
      3.683489,
      NULL,
      NULL,
      0,
      0.058572,
      3.316222,
      0,
      0.504662,
      0,
      0.437742,
      NULL,
      0.864967,
      NULL,
      0.769560,
      1.277978,
      NULL,
      5.299116,
      1,
      0,
      1,
      1,
      1,
      2.596407,
      NULL,
      5.427227,
      2.563332,
      NULL,
      1,
      NULL,
      NULL,
      0.105788,
      NULL,
      NULL,
      2,
      0.889596,
      0.131820,
      3.749913,
      1.885060,
      0.917397,
      2,
      2,
      3.739305,
      1.323009,
      1,
      NULL,
      1,
      0,
      1,
      0.466120,
      1.066350,
      1,
      1,
      1.543694,
      1,
      1,
      0.743214,
      NULL,
      1,
      2,
      0.776938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956145,
      NULL,
      0.744314,
      0.265892,
      3.167754,
      0.303442,
      1,
      0,
      NULL,
      1.221136,
      1,
      1.159814,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.618462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.720688,
      0,
      1,
      NULL,
      1.654832,
      NULL,
      NULL,
      1.136711,
      1.507361,
      NULL,
      4.615268,
      1,
      NULL,
      3.038210,
      4,
      1,
      1,
      0,
      8,
      6,
      2,
      14.946241,
      2,
      NULL,
      0.138961,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.514924,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.062330,
      2.569055,
      6.577160,
      1.007915,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.711776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044404,
      1.165568,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      0.709832,
      1.541568,
      NULL,
      0,
      1.962671,
      1,
      1,
      0.360428,
      1.206488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.833879,
      '00001',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.746727,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


