set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '2002413',
      NULL,
      4,
      NULL,
      1,
      '223443',
      1,
      ' 9-13-1989',
      21,
      NULL,
      NULL,
      NULL,
      0.474690,
      1.782332,
      0.937299,
      0,
      1.351531,
      NULL,
      1.514385,
      1.207133,
      2.714256,
      0.809809,
      3,
      0.244966,
      0,
      0,
      NULL,
      0,
      2.151947,
      NULL,
      1.281993,
      0.442118,
      0.610011,
      0.266786,
      5,
      1,
      3.522540,
      3,
      1,
      0.087982,
      NULL,
      NULL,
      1.538553,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.007897,
      0,
      NULL,
      1,
      0.879438,
      2,
      1,
      NULL,
      1.222818,
      NULL,
      NULL,
      0.273699,
      1,
      1.775564,
      NULL,
      NULL,
      1,
      1.353772,
      2,
      0,
      0,
      1.946415,
      1,
      NULL,
      NULL,
      1.735895,
      NULL,
      NULL,
      1.776718,
      2,
      0.243275,
      0.449610,
      0,
      0.266607,
      1.945297,
      0,
      1,
      0.706298,
      1,
      0.109385,
      0.269177,
      0,
      1.933451,
      NULL,
      1.045488,
      0.992470,
      0,
      NULL,
      0.934355,
      3.875183,
      2,
      0.078336,
      3,
      1.887112,
      3.347410,
      1,
      5,
      2.461444,
      5,
      1.604358,
      0.981440,
      3.092030,
      NULL,
      2.113626,
      0,
      3.897752,
      2,
      NULL,
      4.368563,
      2,
      5.171681,
      7.029465,
      9,
      2,
      0.561372,
      NULL,
      3,
      NULL,
      1,
      1,
      1.363611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      1.023533,
      0.175603,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895297,
      6,
      2.421422,
      4.291048,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.122731,
      1,
      1.596371,
      2,
      NULL,
      0,
      1,
      3.015683,
      0.955077,
      0.156156,
      0.239851,
      1.436208,
      1.863903,
      NULL,
      NULL,
      NULL,
      0,
      0.241403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '11031',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.149715,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


